#include "Motor.h"

Motor::Motor(PinName positivePin, PinName negativePin, PinName pwmPin): 
        positiveOut(positivePin), negativeOut(negativePin), pwmOut(pwmPin) {
        
    pwmOut.period(motorPwmPeriod);
    pwmOut = motorPwmInitDutyCycle;
    
    positiveOut = 0;
    negativeOut = 0;  
    direction = 0; 
    pwmOut = 1;
}

void Motor::start() {
    
    for (float i = 1; i > 0; i -= motorPwmChangeSpeed) {
        pwmOut = i;
        wait(motorPwmWaitTime);
    }        
    pwmOut = 0;
}

void Motor::stop() {

    if(direction == 0)
        return;

    for (float i = 0; i < 1; i += motorPwmChangeSpeed) {
        pwmOut = i;
        wait(motorPwmWaitTime);
    }
    pwmOut = 1;

    positiveOut = 0;
    negativeOut = 0;
    direction = 0;
    wait_ms(1000);
}

void Motor::movePositive() {

    if(direction == 1)
        return;

    if(direction == -1)
        stop();
        
    positiveOut = 1;
    direction = 1;
    start();
}

void Motor::moveNegative() {

    if(direction == -1)
        return;

    if(direction == 1)
        stop();
        
    negativeOut = 1;
    direction = -1;
    start();
}

bool Motor::isMoving() {

    return direction == 0;
}
