#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

EthernetNetIf eth;

int main() {

  printf("Init\n");

  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");

  HTTPClient prowl;
  
  HTTPMap msg;
  msg["apikey"] = "";                   //your unique code you have to make on the website
  msg["providerkey"] = "";
  msg["priority"] = "0";
  msg["application"] = "Mbed";
  msg["event"] = "status";
  msg["description"] = "Message sent from mbed";
  
  HTTPResult r = prowl.post("https://prowl.weks.net/publicapi/add", msg, NULL); 
  if( r == HTTP_OK ){
    printf("Push notification sent with success!\n");
  }else{
    printf("Problem during pushing, return code %d\n", r);
  }
   
  return 0;

}
