#include "mbed.h"
#include "stdlib.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
DigitalIn bplay(p20), bReaksjon(p19);
BusOut bargraph(p21,p22,p23,p24,p25,p26,p27,p28,p29,p30);

Serial pc(USBTX, USBRX);

int play, randNumber, reaksjonstid, resultat;

Timer randTimer, tstart;
Ticker vent;
void start(void);
void reset(void);
void tilbakemelding(void);

int main()
{
    pc.printf("Press play\n");

    while(1) {
        randTimer.start();                  //starter timer for å generere en tilfeldig tid
        play = bplay;                       // tester om "Play" bryteren er trykket
        if (play == 1) {
            start();                            //kjører start funksjonen

            while(play == 1) {

                if(bReaksjon == 1) {                        // etter reaksjons test skrives verdiene til terra term
                    reaksjonstid = tstart.read_ms();
                    pc.printf("Ventetid: %d mS\n", randNumber);
                    pc.printf("Din reaksjonstid er: %d mS\n", reaksjonstid);
                    bargraph = (reaksjonstid/10);
                    tilbakemelding();
                    tstart.reset();
                    reset();
                    break;
                }//if
            }//while
        }//if
    }//while
}//main



void start(void)
{
    bargraph = 0;
    wait(1);
    led1 = 1;
    wait(1);
    led2 = 1;
    wait(1);
    led3 = 1;
    randNumber = randTimer.read_ms();  // leser av verdien i timeren og setter dette som random number
    if(randNumber > 10000) {
        randNumber = reaksjonstid*13;
    }
    randTimer.stop();
    randTimer.reset();
    for (int i = 0; i < randNumber; i++) {
        wait_ms(1);
        if (bReaksjon == 1) {
            tstart.stop();
            tstart.reset();
            pc.printf("Du jukset, Prov igjen\n");         //jukse funksjonen
            bargraph = 2047;                            //tenner hele bargraph hvis juks
            reset();
            break;
        }// if
    }//for
    if (bReaksjon == 1) {
        tstart.stop();
        tstart.reset();
        pc.printf("Du jukset, Prov igjen\n");         //jukse funksjonen
        bargraph = 2047;                            //tenner hele bargraph hvis juks
        reset();
    }// if
    else {
        led1 = led2 = led3 = 0;
        led4 = 1;
        reaksjonstid = 0;                            // Sletter forrige reaksjonstid
        tstart.start();                             //starter timer for reaksjonstid
        } 
}



void reset(void)                                      // tilbakestiller verdier og begynner på nytt
{
    pc.printf("Spill resat, press play\n");
    play = 0;
    randTimer.reset();
    tstart.stop();
    tstart.reset();
    led1 = led2 = led3 = led4 = 0;
}

void tilbakemelding(void)
{

    if(reaksjonstid <= 100) {
        pc.printf("Supert\n");
    } else if(reaksjonstid > 100 && reaksjonstid <= 200) {
        pc.printf("Veldig bra\n");
    } else if(reaksjonstid > 200 && reaksjonstid <= 250) {
        pc.printf("Bra\n");
    } else {
        pc.printf("IKKJE BRA \n");
    }

}//tilbakemelding
