#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
AnalogIn potmeter(p20);
BusOut bar(p21, p22, p23, p24, p25, p26, p27, p28, p29, p30);
Serial pc(USBTX, USBRX);

int teller;
float aIn, v;
Ticker ticker;

void read()
{
    pc.printf("Avlest spenning er %.1f\n", v);
    pc.printf("Tellerverdien er %d\n", teller);
}

int main()
{
    ticker.attach(&read, 1);
    while (1) {
        aIn = potmeter;
        teller = aIn * 10;
        v = potmeter*3.3;
        if(v > 2.0) {
            led1 = 1;
            if(v > 3.0) {
                led2 = 1;
            }//if
            else {
                led2 = 0;
            }
        }//if
        else {
            led1 = led2 = 0;
        }

        switch (teller) {
            case 1:bar = 1;break;
            case 2:bar = 3;break;
            case 3:bar = 7;break;
            case 4:bar = 15;break;
            case 5:bar = 31;break;
            case 6:bar = 63;break;
            case 7:bar = 127;break;
            case 8:bar = 255;break;
            case 9:bar = 511;break;
            case 10:bar = 1023;break;
            default:bar = 0;break;
        }//switch
    }//while
}//main


