//USB Academy - Lab1 rev 01
//_____________________________________________________________//
//======== INCLUDES ===========================================//
//¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯//
#include "mbed.h"
#include "USBSerial.h"
#include "MMA8451Q.h" 

//_____________________________________________________________//
//======== DEFINES & VARIABLES ================================//
//¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯//
USBSerial serial;

#define MMA8451_I2C_ADDRESS (0x1d<<1) 
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

DigitalIn sw1(PTC3); // switch SW1 
DigitalIn sw3(PTC12); // switch SW2

#define ON  0 //switch "ON" detection; LED "ON" state 
#define OFF 1 //switch "OFF" detection; LED "OFF" state 

//======== Data Structure ====================================//
struct KL46_SENSOR_DATA {
    int   sw1State;
    int   sw3State;
    float   accValX;
    float   accValY;
    float   accValZ;
} sensorData;
#define sD sensorData

//_____________________________________________________________//
//======== MAIN() =============================================//
//¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯// 
int main(void)
{
  //====== MAIN/Initialisation ================================//
  
  sw1.mode(PullUp); sw3.mode(PullUp);
  
  while (1)
  {
    //====== MAIN/While loop/Sensing data =====================//

    sD.sw1State = sw1; 
    sD.sw3State = sw3;
    sD.accValX = acc.getAccX(); //accX[-1..1]
    sD.accValY = acc.getAccY(); //accY[-1..1]
    sD.accValZ = acc.getAccZ(); //accZ[-1..1]
     
     //====== MAIN/While loop/Data sending =====================//
     
     
     wait(0.05); // wait 50ms
  }
}
