#include "mbed.h"
#include "MMA8451Q.h"
#include "TextLCD.h"

TextLCD lcd(PTA13, PTD2, PTA4, PTA5, PTC8, PTC9, TextLCD::LCD16x2); // PARA PLACA KL46F



#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)


int cur;
int main(void) {
    MMA8451Q acelerometro(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    
//    printf("MMA8451 ID: %d\n", acelerometro.getWhoAmI());

    while (true) {
        float x, y, z;
        x = rled = 1.0 - abs(acelerometro.getAccX());
        y = gled = 1.0 - abs(acelerometro.getAccY());
        z = bled = 1.0 - abs(acelerometro.getAccZ());
        wait(0.1);
 //       printf("X: %1.4f, Y: %1.4f, Z: %1.4f \n\r", x, y, z);
           
         lcd.clear();
         lcd.setCursor(cur,0);
         lcd.printf("  X     Y     Z" );
         lcd.setCursor(0,1); 
         lcd.printf("%1.2f %1.2f %1.2f", acelerometro.getAccX(), acelerometro.getAccY(), acelerometro.getAccZ());
         
        
        
        
    }
}
