#ifndef BATTERY_LINEAR_ACTUATOR_H
#define BATTERY_LINEAR_ACTUATOR_H

#include <string>
using namespace std;

class Battery_Linear_Actuator
{
    std::string::size_type sz;   // alias of size_t     //TEST 6/21
    
    
    //CLASS VARIABLES and DEFINITIONS
    int motor_absolute_position; 
    //float pot_check_inches;   
    
    int linear_actuator_step_size;   //default confirmed with Dan Edwards
    int linear_actuator_motor_speed;  //5 seconds of full travel between 0 and 175,000 (1000 is about 3 seconds)
    
    int map_check;
    
    int actual_position;
    
//    float la_P_gain;
//    float la_I_gain;
//    float la_D_gain;
    float curr_time;
    float dt;    
    float la_error;
    float la_error_sum;  
    float la_derivative_error;  
    float lastErr;   
    float lastTime;  
    
    float la_integral;
    float la_output;

public:
    Battery_Linear_Actuator();      //pass variables to a constructor (don't need anything passed to it)
    
    
    //Function declarations for KEYBOARD FUNCTIONS  //don't forget the semi-colon!
    string Keyboard_A();
    string Keyboard_D();
    string Keyboard_E();
    string Keyboard_H();
    string Keyboard_I();
    string Keyboard_J();
    string Keyboard_K();
    string Keyboard_L();
    string Keyboard_O();             
    string Keyboard_U();
    void Keyboard_P();  
    string Keyboard_Q();
    
    //new stuff 6/19/17
    string Velocity(int velocity);
    string get_pos();
    
    //new 6/22/17
    string velocity_only(int velocity);
    
    
    string PID_velocity_control(float la_setPoint, float IMU_pitch_angle, float la_P_gain, float la_I_gain, float la_D_gain);
                            
    int MC_readable();
    char MC_getc();    //return the character that is received from MC.getc() 
    string MC_readable_redux();
    
    string Keyboard_LEFT_BRACKET();
    string Keyboard_RIGHT_BRACKET();
    
    string Keyboard_EQUAL_KEY();
    string Keyboard_DASH_KEY();
};

#endif /* BATTERY_LINEAR_ACTUATOR_H_ */