#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Spaceship.h"
#include "Alien.h"
#include "Shoot.h"

class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}
 
Nav_Switch myNav( p9, p6, p7, p5, p8); //pin order on Sparkfun breakout
DigitalOut myled4(LED1);
uLCD_4DGL 
uLCD(p28, p27, p30); // serial tx, serial rx, reset pin;
Serial Blue(p13,p14);

//globals
bool missExists = false;
enum StateType {BEGIN, PLAY , END};
StateType STATE;
int dir1 = 1, dir2 = -1;
int dirs[9] = {1};
int missileX, downerX;
int t;
int killed = 0;

//global variables for main and interrupt routine
volatile bool button_ready = 0;
volatile int  bnum = 0;
volatile int  bhit  ;
//state used to remember previous characters read in a button message
enum statetype {start = 0, got_exclm, got_B, got_num, got_hit};
statetype state = start;
//Interrupt routine to parse message with one new character per serial RX interrupt
void parse_message()
{
    switch (state) {
        case start:
            if (Blue.getc()=='!') state = got_exclm;
            else state = start;
            break;
        case got_exclm:
            if (Blue.getc() == 'B') state = got_B;
            else state = start;
            break;
        case got_B:
            bnum = Blue.getc();
            state = got_num;
            break;
        case got_num:
            bhit = Blue.getc();
            state = got_hit;
            break;
        case got_hit:
            if (Blue.getc() == char(~('!' + ' B' + bnum + bhit))) button_ready = 1;
            state = start;
            break;
        default:
            Blue.getc();
            state = start;
    }
}




void menuAliens(Alien &demo, Alien &demo2) {  //moves the aliens on the demo screen
           demo.erase();
        demo2.erase();

        if (demo.x + 5 >= 124) {
            dir1 = -1;
            }
        else if (demo.x - 5 <= 5 ) {
            dir1 = 1;
            }
        demo.x = demo.x + dir1*3;
//        wait(.05);


        if (demo2.x + 5 >= 124) {
            dir2 = -1;
            }
        else if (demo2.x - 5 <= 5 ) {
            dir2 = 1;
            }
        demo2.x = demo2.x + dir2*3;
        
        demo2.draw();

        demo.draw();
        wait(0.1);
    }
    
    
void moveAliens(Alien aliens[]) {
        aliens[0].erase();
        aliens[1].erase();
        aliens[2].erase();
        aliens[3].erase();
        aliens[4].erase();
        aliens[5].erase();
        aliens[6].erase();
        aliens[7].erase();
        aliens[8].erase();
        
        if (aliens[0].alive & aliens[0].x <= 3) {
             dirs[0]=1;
             aliens[0].y += 15;
             aliens[1].y += 15;
             aliens[2].y += 15;
             aliens[3].y += 15;
             aliens[4].y += 15;
             aliens[5].y += 15;
             aliens[6].y += 15;
             aliens[7].y += 15;
             aliens[8].y += 15;
        }
        if (aliens[0].alive & aliens[0].x >= 98) {
             dirs[0]=-1;
             aliens[0].y += 15;
             aliens[1].y += 15;
             aliens[2].y += 15;
             aliens[3].y += 15;
             aliens[4].y += 15;
             aliens[5].y += 15;
             aliens[6].y += 15;
             aliens[7].y += 15;
             aliens[8].y += 15;
        }
             aliens[0].x += 3*dirs[0];
             aliens[1].x += 3*dirs[0];
             aliens[2].x += 3*dirs[0];
             aliens[3].x += 3*dirs[0];
             aliens[4].x += 3*dirs[0];
             aliens[5].x += 3*dirs[0];
             aliens[6].x += 3*dirs[0];
             aliens[7].x += 3*dirs[0];
             aliens[8].x += 3*dirs[0];
             
                                 for (int k = 0; k<9; k++)
                        {
                            if(aliens[k].alive)
                            {
                                aliens[k].draw();
                            }
                    }  
    }
    
    
    
    
    
    
int main() {
        
        uLCD.baudrate(3000000); // set to 500000 to increase smooth gameplay
        uLCD.color(RED);
        uLCD.set_font(FONT_7X8);
        uLCD.text_width(2); //4X size text
        uLCD.text_height(2); //4X size text
    Blue.attach(&parse_message,Serial::RxIrq);

        STATE = BEGIN;
        uLCD.text_mode(TRANSPARENT);
        
        uLCD.locate(0,5);
        for (int i = 0; i < 128; i+=15) {
            
            for (int j = 0; j <128; j+=15) {
                
                uLCD.pixel(j, i, WHITE);
                
            }
            
        }
        uLCD.locate(3,40);
        uLCD.filled_rectangle(0,40,128, 80,BLUE);
        
        uLCD.text_string("SPACE \n RACERS", 0, 3, FONT_7X8, RED);
            uLCD.text_width(1); //4X size text
        uLCD.text_height(1); //4X size text
      uLCD.text_string("Press right to \n begin!", 0, 11, FONT_7X8, RED);

        Alien demo = Alien(110,112);
        Alien demo2 = Alien(2,20);



        while(1) {
    switch (STATE) {
        
        case (BEGIN): 
            
        menuAliens(demo, demo2);
        
        if (myNav.right()) {
            uLCD.cls();
                uLCD.text_mode(TRANSPARENT);
            
            STATE = PLAY;
            }
            
        break;
        
        case (PLAY):        
        

                
        Spaceship ME = Spaceship();    
                    ME.draw();
        Alien aliens[9];


        aliens[0] =  Alien(10,15);
        aliens[1] =  Alien(25,15);
        aliens[2] =  Alien(40,15);
        aliens[3] =  Alien(10,30);
        aliens[4] =  Alien(25,30);
        aliens[5] =  Alien(40,30);
        aliens[6] =  Alien(10,45);
        aliens[7] =  Alien(25,45);
        aliens[8] =  Alien(40,45);
            Shoot missile = Shoot(ME.x, 128);
            Shoot downer = Shoot(-100, 200);

            while(ME.isAlive() && killed <9) { //change to while alive
            
                            for (int i = 10; i < 128; i+=35) {
            
            for (int j = 0; j <128; j+=35) {
                
                uLCD.pixel(j, i, WHITE);
                
            }
            
        }    
        
        uLCD.filled_rectangle(0,0,128, 8,BLUE);

        uLCD.locate(0,0);
        uLCD.text_width(1); //4X size text
        uLCD.text_height(1); //4X size text
        uLCD.color(RED+GREEN);
        uLCD.printf("Lives:%i   ",3-ME.hits);
        uLCD.printf("Kills:%i",killed);



               
               moveAliens(aliens);
               
                     ME.draw();
//                A1.draw();


        
               
                if (myNav.up()|| (button_ready && (bnum=='5'))) {
                    missile.erase();
                    missile.alive = true;
                    missExists = true;
                    missile.x = ME.x;
                    missile.y = 128;
                    missile.draw();
                    button_ready = 0;
                    }
                     
                    
                   if (myNav.left() || (button_ready && (bnum=='7'))  ) {
                        ME.erase();

                        ME.x -= 6;
                        ME.draw();
                                    myled4 = !myled4;
                        button_ready = 0;

                }


                    

                if (myNav.right() || (button_ready && (bnum=='8')) ) {
                        ME.erase();

                         ME.x += 6;
                         ME.draw();
                        button_ready = 0;
                }
                
                    if (missile.alive) {
                    missile.erase();
                    missile.y-=7;
                    missile.draw();
                    }
                    if (downer.alive) {
                        downer.erase();
                        downer.y +=10;
                        downer.x = downerX;
                        downer.draw();
                        }
                    if (missile.y - 6 <=9) {
                        missile.alive = false;
                        missile.erase();
                        missile.x = -100;
                        missile.y = 200; 
                        }
                        
                    for (int k = 8; k>=0; k--)
                        {       // IF U KILLED AN ALIEN
                            if(missile.alive && aliens[k].alive && missile.x - 1<= aliens[k].x+5  & missile.x+1>= aliens[k].x-5 && missile.y-7 <= aliens[k].y+6 && missile.y>= aliens[k].y-1)
                            {aliens[k].alive =false;
                            aliens[k].erase();
                            missile.alive = false;
                            missile.erase();
                            missile.x = -100;
                            missile.y = 200;
                            killed ++;
                            
                            }
                            if ( aliens[k].y+6>=125){
                            ME.alive = false;
                            break;                            
                            }
                             t++;
                            if ( aliens[k].alive && t%100==0) {
                                downerX=aliens[k].x;
                                downer.x = downerX;
                                downer.y = aliens[k].y+4;
                                downer.draw();

                                downer.alive = true;
                                }
                                
                            
                    }
                    

                    if (downer.y >=128) {
                        downer.alive = false;
                        downer.erase();
                        }
                    if (downer.y+6 >= ME.y-3 && downer.x-1 >= ME.x-5 && downer.x+1 <= ME.x+5) {
                        ME.hits++;
                        downer.alive =false;
                        downer.erase();
                        
                        downer.x = -100;
                        downer.y = -100;
                        
        uLCD.filled_circle(ME.x , ME.y , 4 , RED); 
        wait(.2);
        uLCD.filled_circle(ME.x , ME.y , 4 , BLUE); 
                wait(.2);

        uLCD.filled_circle(ME.x , ME.y , 4 , RED); 
                wait(.2);

        uLCD.filled_circle(ME.x , ME.y , 4 , BLUE); 

                        
                        }
                        
            }
    STATE = END;
        break;
    case (END):
        uLCD.cls();
        uLCD.filled_rectangle(0,40,128, 80,BLUE);

        uLCD.text_mode(TRANSPARENT);
        uLCD.text_width(2); //4X size text
        uLCD.text_height(2); //4X size text
        if(ME.hits==3) {
        uLCD.text_string("GAME \n OVER!!", 0, 3, FONT_7X8, RED);

        } else {
        uLCD.text_string("YOU SAVED \nTHE WORLD!!", 0, 3, FONT_7X8, RED);
            }
            
            
        wait(5);
        
        uLCD.text_width(1); //4X size text
        uLCD.text_height(1); //4X size text
                uLCD.color(WHITE);

      uLCD.text_string("Press right to \n restart!", 0, 11, FONT_7X8, RED);
                uLCD.color(WHITE);

        wait(1);
        ME.hits = 0;
        ME.alive = true;
        ME.x = 0;
        ME.y = 127;
        killed = 0;
        STATE = BEGIN;
    }

}
}
