// Module..: Photo_LED
// Version.: 1.0
// Chip....: STM32F411RE
// Date....: November 2014
// Author..: UJ
//-----------------------------------------------------------------------------

// This program is a simple demonstration how a normal LED can be used as a
// photo diode. The hardware platform I have used is the NUCLEO F411RE, but
// the principle will run on every modern controller with high-impedance
// Schmitt-trigger inputs.
//
// Harware sketch:
//      _____________________
//     |                     |
//     |                   __|__
//     |                   \   / LED (20mA, green or red)
//     |                    \ /
//     |                  -------
//     |                     |
//     |                    _|_
//     |                   |   |
//     |                   |100| Ohm
//     |                   |_ _|
//     |                     |
//     |                     |
//     |                     |
//     Anode Pin (PC10)      Cathode Pin (PC11)
//
// How it works:
// In the first phase the LED is turned on in it´s normal mode for 50ms.
// In the second phase the LED is driven with a reversed voltage for 5ms
// (anode negative, cathode positive). This will charge the internal capacity
// with reverse potential. Then the anode pin is configured as a high-impedance
// input pin. It takes some time until the voltage at the anode pin will raise
// above the Schmitt-trigger level. This time is depending on the over all
// circuit resistance and the ambient light.
//
// Hint:
// The capacity of the LED is very low (5..35pF). Do not place the board
// to a conductive ground. Even humidity will change the blink frequency.
// Do not touch the components.
//-----------------------------------------------------------------------------

#include "mbed.h"
//-----------------------------------------------------------------------------

#define IWDG_RESET() (IWDG->KR = 0xAAAA)
//-----------------------------------------------------------------------------

Serial terminal(USBTX, USBRX);

DigitalInOut anode_pin(PC_10);
DigitalOut cathode_pin(PC_11);
//-----------------------------------------------------------------------------

int main(void)
{
  unsigned char cnt;

  terminal.baud(115200);
  terminal.printf("Photo LED\r\n");

  while (1)
  {
    IWDG_RESET();

    // Set normal LED operation, turn on LED for 50ms
    // Setup PC10 as output
    anode_pin.output();

    // Turn on LED for 50ms
    // Set anode (PC10) high and cathode (PC11) low
    anode_pin = 1;
    cathode_pin = 0;

    for (cnt = 0; cnt < 10; cnt++)
    {
      wait(0.005f);
      IWDG_RESET();
    }

    // Apply reverse voltage to the LED for reverse charging the LED´s capacity
    // Set anode (PC10) low and cathode (PC11) high
    anode_pin = 0;
    cathode_pin = 1;
    wait(0.005f);

    // Setup anode (PC10) as input
    anode_pin.input();

    // Wait until the input voltage raises above the Schmitt trigger level
    // This time is strongly ambient light depending
    while (anode_pin.read() == 0)
    {
      IWDG_RESET();
      wait(0.005f);
    }
  }
}
