#include "mbed.h"
#include "mcp3208.h"

MCP3208 input1(PA_7, PA_6, PA_5, PB_0); //MCP3208(PinName mosi, PinName miso, PinName clk, PinName cs)

Serial pc(USBTX, USBRX);
//Serial pc(PA_2, PA_3);

Ticker datalog;

int data0 = 0;
int data1 = 0;
int data2 = 0;
int data3 = 0;
int data4 = 0;
int data5 = 0;

bool tickerActivated = false;

void log_data()
{
    tickerActivated = true;
}

int main()
{
    pc.baud(921600);
    pc.printf("Working!!\n\r");

    datalog.attach_us(&log_data,1000); // 1000us = 1ms
        
    while(1) {
        data0 = input1.binary(0);
        data1 = input1.binary(1);
        data2 = input1.binary(2);
        data3 = input1.binary(3);
        data4 = input1.binary(4);
        data5 = input1.binary(5);

        if(tickerActivated == true) {
            tickerActivated = false;
            pc.printf("%04d,%04d,%04d,%04d,%04d,%04d\n\r",data0,data1,data2,data3,data4,data5);
        }

    }
}


