#include "mbed.h"
#include "mcp3208.h"

MCP3208 input1(PA_7, PA_6, PA_5, PA_4); //MCP3208(PinName mosi, PinName miso, PinName clk, PinName cs)
//MCP3208 input1(PB_5, PB_4, PB_3, PA_4);

//MCP3208 input1(p5, p6, p7, p8);

//Serial pc(dp16,dp15);
// Serial pc(p9,p10);
 Serial pc(USBTX, USBRX);

Ticker datalog;
Timer t;

char datastr0[5];
char datastr1[5];
char datastr2[5];
char datastr3[5];
char datastr4[5];
char datastr5[5];

char datastr6[5];

// Credit: Erik Olieman
// http://developer.mbed.org/questions/5149/Serial-port-on-LPC1114-is-slow/
void intToString(char *buffer, int value)
{
    int temp;
    temp = value / 1000;
    buffer[0] = temp + '0';
    value = value - temp * 1000;

    temp = value / 100;
    buffer[1] = temp + '0';
    value = value - temp * 100;

    temp = value / 10;
    buffer[2] = temp + '0';
    value = value - temp * 10;

    temp = value / 1;
    buffer[3] = temp + '0';
    value = value - temp * 1;

    buffer[4] = '\0';
}

bool tickerActivated = false;

void log_data()
{
    tickerActivated = true;
}

int main()
{
    int tt = 0;
    t.start();

    pc.baud(921600);
    pc.printf("Working!!\n\r");

    datalog.attach_us(&log_data,1000); // 1000us = 1ms

    while(1) {
        intToString(datastr0,input1.binary(0));
        intToString(datastr1,input1.binary(1));
        intToString(datastr2,input1.binary(2));
        intToString(datastr3,input1.binary(3));
        intToString(datastr4,input1.binary(4));
        intToString(datastr5,input1.binary(5));

        // Timing methods to verify 1 ms loop time / 1 kHz update speed
        // tt = t.read_ms();
        tt++;
        if(tt>=10000) {
            tt = 0;
        }
        intToString(datastr6,tt);

        if(tickerActivated == true) {
            tickerActivated = false;
            pc.printf("%s,%s,%s,%s,%s,%s\n\r",datastr0,datastr1,datastr2,datastr3,datastr4,datastr5);
        }

    }
}


