#include "mbed.h"

//https://developer.mbed.org/users/igor_m/code/benchmark/
/* This program determines the time it takes to perform floating point
    and integer operations.
    To determine the time it takes, a Timer is used to measure the time
    it takes to complete a large amount of iterations. The time for a single
    operation can then be determined.

    To increase accuracy of the results, an empty for loop is timed to determine
    the loop overhead and the overhead is subtracted from the time it takes to
    complete the operation loop.
*/

#define ITERATIONS 1000000    // Number of calculations.
#define CLOCK 64              // Clock freqency in MHz
Timer timer;                       // Timer..

Serial pc(USBTX, USBRX);
float number_of_cycles, single_operation_time;
//volatile int a, b, c;              // Int operands and result. Must be volatile!
volatile float a, b, c;            // Float operands and result. Must be volatile!
//volatile double a, b, c;            // Float operands and result. Must be volatile!

int main() {

    // Apparently I'm not getting full speed!? 
    // https://developer.mbed.org/forum/mbed/topic/229/?page=1
    // https://developer.mbed.org/questions/55557/CPU-clock-of-upto-100MHz/  
    printf("SystemCoreClock = %d MHz\r\n", SystemCoreClock/1000000);
    // Need external crystal to make it run faster?
    // https://developer.mbed.org/users/dreschpe/code/ST_401_84MHZ/
    // https://developer.mbed.org/users/oliverb/notebook/crystal-oscillator-notes/

    unsigned int i, for_time, total_time, operation_time;
    a=2.3;
    b=5.33;

    timer.reset();      // Reset timer
    timer.start();      // Start timer
    pc.printf("Operations in progress.. May take some time.\r\n");
    /* Determine loop overhead */
    for (i=0; i<ITERATIONS; i++){}
    for_time=timer.read_us();
    timer.stop();

    /* Determine the total loop time */
    timer.reset();
    timer.start();
    
    /* The operation takes place in the body of
    this for loop. */
    for (i=0; i<ITERATIONS; i++){
        
//        a = b;
//        c = a+b;
//        c = a*b;
//        c = a/b;
//        a = sqrt(b);
//        a = log(b);
//        a = tanh(b);
//        a = (10*pow(b,3) + 105*b)/(pow(b,4) + 45*pow(b,2) + 105);
        a = (10*b*b*b + 105*b)/(b*b*b*b + 45* + 105);
    }
    
    total_time=timer.read_us();

    operation_time = total_time-for_time;   // Calculate the time it took for the number of operations

    single_operation_time=float(operation_time)/float(ITERATIONS);
    number_of_cycles = single_operation_time*CLOCK;

    pc.printf("for overhead: \t\t%dus \r\n", for_time);
    pc.printf("total time: \t\t%dus \r\n", total_time);
    pc.printf("%d calculations took:\t%dus \r\n", ITERATIONS, operation_time);
    pc.printf("single operation took: \t\t%fus \r\n", single_operation_time);
    pc.printf("single operation took: \t\t%.3f cycles \r\n", number_of_cycles);
}
