#include "mbed.h"
#include "EthernetNetIf.h"
#include "MQTTClient.h"
#include "TextLCD.h"

EthernetNetIf ethernet;

Serial pc(USBTX, USBRX);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2B); // rs, e, d4-d7

IpAddr serverIpAddr(192,168,0,2);  /*Sever ip address*/

void callback(char* topic, char* payload); /*Callback function prototype*/

MQTTClient mqtt(serverIpAddr, 1883, callback);

void callback(char* topic, char* payload) {
    printf("Topic: %s\r\n", topic);
    printf("Payload: %s\r\n\r\n", payload);
    //Send incoming payloads back to topic "/mbed".
    printf("Topic:  ");
    printf(topic, "\r\n");
    printf("Payload:  ");
    printf(payload, "\r\n");

    char *string_1 = "LED1";
    char *string_2 = "LED2";
    char *string_3 = "LED3";
    char *string_4 = "LED4";

    if (strcmp(payload, string_1)==0) {
        printf(payload);
        printf("Setting LED1");
        myled1 = 1;
    } else if (strcmp(payload, string_2)==0) {
        printf(payload);
        printf("'Setting LED2");
        myled2 = 1;
    } else if (strcmp(payload, string_3)==0) {
        printf(payload);
        printf("Setting LED3");
        myled3 = 1;
    } else if (strcmp(payload, string_4)==0) {
        printf(payload);
        printf("Setting LED4");
        myled4 = 1;
    } else {
        lcd.printf(payload);
    }


    //pc.printf(payload);
    //while(1) {pc.putc(pc.getc()

    mqtt.publish("/mbed", payload);


}

int main() {
    printf("\r\n############### MQTTClient Session  ##&#65283;&#65283;#######\r\n\r\n");

    EthernetErr ethErr = ethernet.setup();
    if (ethErr) {
        printf("Ethernet Error %d\r\n", ethErr);
        return -1;
    }

    char clientID[] = "mbed";   /*Client nanme show for MQTT server*/
    char pub_topic[] = "/mbed";   /*Publish to topic : "/mbed" */
    char sub_topic[] = "/kivy";   /*Subscribe to topic : "/mirror" */

    if (!mqtt.connect(clientID)) {
        printf("\r\nConnect to server failed ..\r\n");
        return -1;
    }
    printf("\r\nConnect to server sucessed ..\r\n");

    mqtt.publish(pub_topic, "Hello here is mbed...");
    mqtt.subscribe(sub_topic);

    int flag = 0;
    /*Keep alive for 300s or 5mins*/
    while (flag < 300) {
        Net::poll();
        wait(1);
        flag++;
        mqtt.live();
    }

    mqtt.disconnect();

    printf("#### End of the session.. ####\r\n\r\n");
}