#include "mbed.h"

Serial pc(USBTX, USBRX);

PwmOut motor1(p21);
PwmOut motor2(p22);

int motor1_width = 1500;
int motor2_width = 1500;

unsigned char input_pc = 0;

int main() {
    motor1.period_ms(20);
    motor2.period_ms(20);
    while(1) {
        if(pc.readable())
        {
            input_pc = pc.getc();
            
            if(input_pc == 'w')
            {
                motor1_width = 1500;
            }
            else if(input_pc == 'e')
            {
                motor1_width+=1;
            }
            else if(input_pc == 'q')
            {
                motor1_width-=1;
            }
            else if(input_pc == 'd')
            {
                motor1_width+=10;
            }
            else if(input_pc == 'a')
            {
                motor1_width-=10;
            }
            else if(input_pc == 't')
            {
                motor2_width = 1500;
            }
            else if(input_pc == 'y')
            {
                motor2_width+=1;
            }
            else if(input_pc == 'r')
            {
                motor2_width-=1;
            }
            else if(input_pc == 'h')
            {
                motor2_width+=10;
            }
            else if(input_pc == 'f')
            {
                motor2_width-=10;
            }
        }
        
        pc.printf("%d  %d\r\n",motor1_width,motor2_width);
        
        motor1.pulsewidth_us(motor1_width);
        motor2.pulsewidth_us(motor2_width);
        
        wait(0.01);
    }
}
