#include "mbed.h"
#include "HX711.h"

DigitalOut gpo(D0);
DigitalOut led(LED_BLUE);
HX711 scale(A0, A1);

AnalogIn scaleRaw(A3);
Serial pc(USBTX, USBRX);    // USB Serial Terminal
float calibration_factor = 1000; //-7050 worked for my 440lb max scale setup
int averageSamples = 100;

int main(void)
{
    pc.printf("Starting Scale");
    pc.printf("HX711 calibration sketch");
    pc.printf("Remove all weight from scale");
    pc.printf("After readings begin, place known weight on scale");
    pc.printf("Press + or a to increase calibration factor");
    pc.printf("Press - or z to decrease calibration factor");
    
      
    scale.setScale(0);
    scale.tare(); //Reset the scale to 0
    
    long zero_factor = scale.averageValue(averageSamples); //Get a baseline reading
    pc.printf("Zero factor: %.4f\n" , zero_factor); //This can be used to remove the need to tare the scale. Useful in permanent scale projects.
    
    while (true) {
        scale.setScale(calibration_factor); //Adjust to this calibration factor
        float weight = scale.getGram();
        //float raw = scaleRaw.read();
        pc.printf("Reading: %.2f\n", weight);
        //pc.printf("Raw Value: %.7f\n", raw);
        pc.printf(" calibration_factor: %.2f\n", calibration_factor);


       if(pc.readable()) {
            char temp = pc.getc();
            if(temp == '+' || temp == 'a')
               calibration_factor += 10;
            else if(temp == '-' || temp == 'z')
                calibration_factor -= 10;
            }
        gpo = !gpo; // toggle pin
        led = !led; // toggle led
        wait(0.2f);
    }
}