
/*
    Sequential Fade the RGB led on Freescale KL25 board 
    
    Version 1.0 - 01/29/2014  Maurizio Conti
*/

#include "mbed.h"

PwmOut ledRed(PTB18);
PwmOut ledGreen(PTB19);
PwmOut ledBlue(PTD1);

void FadeLed( PwmOut led, float step )
{
    // if FadeIn, start off, else start on
    if( step < 0 )
        led = 1.0;
    else
        led = 0;
        
    // Fade the led
    for(int x=0 ; x<100; x++ ) {
        wait(0.007);
        led = led + step;
    }

    // if FadeIn, stop on, else stopo off
    if( step < 0 )
        led = 0;
    else
        led = 1;
}

int main()
{
    ledBlue=1.0;
    ledGreen=1.0;
    ledRed=1.0;
    
    while(1) {
        FadeLed( ledRed, -0.01);
        FadeLed( ledRed, 0.01);
        FadeLed( ledGreen, -0.01);
        FadeLed( ledGreen, 0.01);
        FadeLed( ledBlue, -0.01);
        FadeLed( ledBlue, 0.01);
    }
}
