#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define ON  0
#define OFF !ON

//Setup the interrupts for the MMA8451Q
InterruptIn accInt1(PTA14);
InterruptIn accInt2(PTA15);//not used in this prog but this is the other int from the accelorometer

uint8_t togstat=0;//Led status
DigitalOut bled(LED_BLUE);

void tapTrue(void){
    printf( "-%d\r\n", togstat );
    togstat = !togstat;
    
    if(togstat)
        bled = 0;
    else
        bled=1;    
}


Ticker tick;
DigitalOut led1(LED_RED);
DigitalOut led2(LED_GREEN);

int main() {
        
    // Accelerometer 
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    acc.setDoubleTap();//Setup the MMA8451Q to look for a double Tap
    accInt1.rise(&tapTrue);//call tapTrue when an interrupt is generated on PTA14

    while(1)
    {
        printf("X:%001.2f Y:%001.2f Z:%001.2f\r", acc.getAccX(), acc.getAccY(), acc.getAccZ() ); 
        wait(0.02);
    }
}