/**
 * @brief       iAQ_Core.c
 * @details     Indoor air quality module, I2C interface.
 *              Functions file.
 *
 *
 * @return      N/A
 *
 * @author      Manuel Caballero
 * @date        8/June/2018
 * @version     8/June/2018    The ORIGIN
 * @pre         N/A.
 * @warning     N/A
 * @pre         This code belongs to Nimbus Centre ( http://www.nimbus.cit.ie ).
 */

#include "iAQ_Core.h"


iAQ_Core::iAQ_Core ( PinName sda, PinName scl, uint32_t addr )
    : _i2c            ( sda, scl )
    , _iAQ_Core_Addr  ( addr )
{
    _i2c.frequency( 100000 );
}


iAQ_Core::~iAQ_Core()
{
}



/**
 * @brief       iAQ_Core_GetNewReading ( iAQ_Core_data_t* )
 *
 * @details     It performs a new parameters reading from the sensor.
 *
 * @param[in]    N/A
 *
 * @param[out]   myData:            All parameters: Prediction + Status Flag + Resistance + Tvoc.
 *
 *
 * @return       Status of iAQ_Core_GetNewReading.
 *
 *
 * @author      Manuel Caballero
 * @date        8/June/2018
 * @version     8/June/2018     The ORIGIN
 * @pre         Measurement interval ( continuous ): 1s | Measurement interval ( pulsed ): Max. 11s.
 * @warning     First functional reading after start up is 5 minutes.
 */
iAQ_Core::iAQ_Core_status_t  iAQ_Core::iAQ_Core_GetNewReading ( iAQ_Core_data_t* myData )
{
    char     cmd[9]    =   { 0 };
    uint32_t aux       =   0;


    /* Get the data */
    aux = _i2c.read ( _iAQ_Core_Addr, &cmd[0], sizeof( cmd )/sizeof( cmd[0] ) );


    /* Update the parameters    */
    myData->pred         =  ( ( cmd[0] << 8 ) + cmd[1] );                           // Prediction = ( byte0 * 2^8 ) + byte1
    myData->status       =  ( iAQ_Core_status_flag_t )cmd[2];
    myData->resistance   =  ( ( cmd[4] << 16 ) + ( cmd[5] << 8 ) + cmd[6] );        // Resistance = ( byte4 * 2^16 ) + ( byte5 * 2^8 ) + byte6
    myData->Tvoc         =  ( ( cmd[7] << 8 ) + cmd[8] );                           // Tvoc       = ( byte7 * 2^8 ) + byte8




    if ( aux == I2C_SUCCESS )
        return   iAQ_Core_SUCCESS;
    else
        return   iAQ_Core_FAILURE;
}