/**
 * @brief       MCP41XXX_42XXX.h
 * @details     Single/Dual Digital Potentiometer with SPI™ Interface.
 *              Header file.
 *
 *
 * @return      N/A
 *
 * @author      Manuel Caballero
 * @date        21/August/2018
 * @version     21/August/2018    The ORIGIN
 * @pre         N/A.
 * @warning     N/A
 * @pre         This code belongs to AqueronteBlog ( http://unbarquero.blogspot.com ).
 */
#ifndef MCP41XXX_42XXX_H
#define MCP41XXX_42XXX_H

#include "mbed.h"
/**
    Example:
@code

@endcode
*/


/*!
 Library for the MCP41XXX_42XXX 3D Single/Dual Digital Potentiometer with SPI™ Interface.
*/
class MCP41XXX_42XXX
{
public:
    /* Command Byte */
    /**
      * @brief   COMMAND SELECTION BITS
      */
    typedef enum {
        MCP41XXX_42XXX_COMMAND_NONE         =   ( 0b00 << 4 ),      /*!<   No Command will be executed                                                                                                          */
        MCP41XXX_42XXX_COMMAND_WRITE_DATA   =   ( 0b01 << 4 ),      /*!<   Write the data contained in Data Byte to the potentiometer(s) determined by the potentiometer selection bits                         */
        MCP41XXX_42XXX_COMMAND_SHUTDOWN     =   ( 0b10 << 4 )       /*!<   Potentiometer(s) determined by potentiometer selection bits will enter Shutdown Mode. Data bits for this command are 'don't cares'   */
    } MCP41XXX_42XXX_command_selection_bits_t;


    /**
      * @brief   POTENTIOMETER SELECTION BITS
      */
    typedef enum {
        MCP41XXX_42XXX_POTENTIOMETER_DUMMY_CODE                     =   ( 0b00 << 0 ),      /*!<   Dummy Code: Neither Potentiometer affected               */
        MCP41XXX_42XXX_POTENTIOMETER_COMMAND_POTENTIOMETER_0        =   ( 0b01 << 0 ),      /*!<   Command executed on Potentiometer 0                      */
        MCP41XXX_42XXX_POTENTIOMETER_COMMAND_POTENTIOMETER_1        =   ( 0b10 << 0 ),      /*!<   Command executed on Potentiometer 1                      */
        MCP41XXX_42XXX_POTENTIOMETER_COMMAND_BOTH_POTENTIOMETERS    =   ( 0b11 << 0 )       /*!<   Command executed on both Potentiometers */
    } MCP41XXX_42XXX_potentiometer_selection_bits_t;





#ifndef MCP41XXX_42XXX_VECTOR_STRUCT_H
#define MCP41XXX_42XXX_VECTOR_STRUCT_H
    typedef struct {
        uint8_t Dn;
    } MCP41XXX_42XXX_vector_data_t;
#endif



    /**
      * @brief   INTERNAL CONSTANTS
      */
    typedef enum {
        MCP41XXX_42XXX_SUCCESS     =       0,
        MCP41XXX_42XXX_FAILURE     =       1,
        SPI_SUCCESS                =       1
    } MCP41XXX_42XXX_status_t;




    /** Create an MCP41XXX_42XXX object connected to the specified SPI pins.
      *
      * @param mosi     SPI Master Output Slave Input
      * @param miso     SPI Master Input Slave Output
      * @param sclk     SPI clock
      * @param cs       SPI Chip Select
      * @param freq     SPI frequency in Hz.
      */
    MCP41XXX_42XXX ( PinName mosi, PinName miso, PinName sclk, PinName cs, uint32_t freq );

    /** Delete MCP41XXX_42XXX object.
     */
    ~MCP41XXX_42XXX();

    /** It updates the wiper value on the given channel.
        */
    MCP41XXX_42XXX_status_t  MCP41XXX_42XXX_SetWiper            ( MCP41XXX_42XXX_potentiometer_selection_bits_t myChannel, MCP41XXX_42XXX_vector_data_t myWiperValue );

    /** It performs a software shutdown.
        */
    MCP41XXX_42XXX_status_t  MCP41XXX_42XXX_SoftwareShutdown    ( MCP41XXX_42XXX_potentiometer_selection_bits_t myChannel                                            );
    
private:
    SPI         _spi;
    DigitalOut  _cs;
};

#endif
