/**
 * @brief       MCP41XXX_42XXX.cpp
 * @details     Single/Dual Digital Potentiometer with SPI™ Interface.
 *              Function file.
 *
 *
 * @return      N/A
 *
 * @author      Manuel Caballero
 * @date        21/August/2018
 * @version     21/August/2018    The ORIGIN
 * @pre         N/A.
 * @warning     N/A
 * @pre         This code belongs to AqueronteBlog ( http://unbarquero.blogspot.com ).
 */

#include "MCP41XXX_42XXX.h"


MCP41XXX_42XXX::MCP41XXX_42XXX ( PinName mosi, PinName miso, PinName sclk, PinName cs, uint32_t freq )
    : _spi ( mosi, miso, sclk )
    , _cs  ( cs )
{
    _spi.frequency( freq );
    _spi.format   ( 8, 0 );                                                     // 8-bits, mode0: CPOL = 0 | CPHA = 0
}


MCP41XXX_42XXX::~MCP41XXX_42XXX()
{
}



/**
 * @brief       MCP41XXX_42XXX_SetWiper   ( MCP41XXX_42XXX_potentiometer_selection_bits_t , MCP41XXX_42XXX_vector_data_t )
 *
 * @details     It updates the wiper value on the given channel.
 *
 * @param[in]    myChannel:         Potentiometer 0/1/both.
 * @param[in]    myWiperValue:      New wiper value.
 *
 * @param[out]   N/A.
 *
 *
 * @return       Status of MCP41XXX_42XXX_SetWiper.
 *
 *
 * @author      Manuel Caballero
 * @date        21/August/2018
 * @version     21/August/2018   The ORIGIN
 * @pre         The MCP42XXX contains two independent channels in a 14-pin PDIP, SOIC or TSSOP package while the MCP41XXX is a single-channel device
 *              and is offered in an 8-pin PDIP or SOIC package.
 * @warning     N/A.
 */
MCP41XXX_42XXX::MCP41XXX_42XXX_status_t  MCP41XXX_42XXX::MCP41XXX_42XXX_SetWiper ( MCP41XXX_42XXX_potentiometer_selection_bits_t myChannel, MCP41XXX_42XXX_vector_data_t myWiperValue )
{
    char   cmd[]   =    { 0, 0 };
    int    mySPI_status;


    /* Make the command byte and the new wiper value, update the register then     */
    cmd[0]           =   (char)( MCP41XXX_42XXX_COMMAND_WRITE_DATA | myChannel );
    cmd[1]           =   (char)myWiperValue.Dn;
    _cs              =   0;
    mySPI_status     =   _spi.write ( &cmd[0], sizeof( cmd )/sizeof( cmd[0] ), &cmd[0], 0 );
    _cs              =   1;




    if ( mySPI_status == SPI_SUCCESS )
    {
        return   MCP41XXX_42XXX_SUCCESS;
    }
    else
    {
        return   MCP41XXX_42XXX_FAILURE;
    }
}



/**
 * @brief       MCP41XXX_42XXX_SoftwareShutdown   ( MCP41XXX_42XXX_potentiometer_selection_bits_t )
 *
 * @details     It performs a software shutdown.
 *
 * @param[in]    myChannel:         Potentiometer 0/1/both.
 *
 * @param[out]   N/A.
 *
 *
 * @return       Status of MCP41XXX_42XXX_SoftwareShutdown.
 *
 *
 * @author      Manuel Caballero
 * @date        21/August/2018
 * @version     21/August/2018   The ORIGIN
 * @pre         The MCP42XXX contains two independent channels in a 14-pin PDIP, SOIC or TSSOP package while the MCP41XXX is a single-channel device
 *              and is offered in an 8-pin PDIP or SOIC package.
 * @warning     N/A.
 */
MCP41XXX_42XXX::MCP41XXX_42XXX_status_t  MCP41XXX_42XXX::MCP41XXX_42XXX_SoftwareShutdown ( MCP41XXX_42XXX_potentiometer_selection_bits_t myChannel )
{
    char    cmd[]   =    { 0, 0 };
    int     mySPI_status;


    /* Make the command byte, the new wiper value does not take place, update the register then     */
    cmd[0]           =   (char)( MCP41XXX_42XXX_COMMAND_SHUTDOWN | myChannel );
    cmd[1]           =   0;
    _cs              =   0;
    mySPI_status     =   _spi.write ( &cmd[0], sizeof( cmd )/sizeof( cmd[0] ), &cmd[0], 0 );
    _cs              =   1;




    if ( mySPI_status == SPI_SUCCESS )
    {
        return   MCP41XXX_42XXX_SUCCESS;
    }
    else
    {
        return   MCP41XXX_42XXX_FAILURE;
    }
}
