#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

extern "C" int32_t CountItems();
extern "C" int32_t SumAllFrequencies();
extern "C" uint8_t * GetWordAt(int32_t i);
extern "C" int16_t GetFreqAt(int32_t i);

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

InterruptIn user_button(USER_BUTTON);

void button_pressed(){
    lcd.Clear(LCD_COLOR_BLACK);
}

void button_released(){
    lcd.Clear(LCD_COLOR_RED);
}

void button_callback(){
    user_button.rise(&button_pressed);
    user_button.fall(&button_released);
}

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
  
    BSP_LCD_SetFont(&Font20);
  
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"DEMO", CENTER_MODE);
    wait(1);
  
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
    if (status != TS_OK)
    {
      lcd.Clear(LCD_COLOR_RED);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    }
    else
    {
      lcd.Clear(LCD_COLOR_GREEN);
      lcd.SetBackColor(LCD_COLOR_GREEN);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
    
    wait(1);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    
    
    uint8_t *word;
    int16_t wordfrequency = 0;
    float prct; 
    int32_t MAX;
    int32_t totalfrequency;
    
    
    MAX = CountItems();
    MAX = MAX + 1;
    sprintf((char*)text, "MAX=%d", MAX);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, LEFT_MODE);
    
    totalfrequency = SumAllFrequencies();
    /*wordfrequency = GetFreqAt(2);
    prct = ((wordfrequency)/((float)totalfrequency));
    sprintf((char*)text, "percent=%f", prct);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, LEFT_MODE);*/
    int num = 2;

    while(1)
    {
        button_callback();
        for(int32_t i = 1; i < MAX; i++){
          word = GetWordAt(i);
          wordfrequency = GetFreqAt(i);
          sprintf((char*)text, "wordfreq=%d", wordfrequency);
          lcd.DisplayStringAt(0, LINE(num), (uint8_t *)&text, LEFT_MODE);
          prct = ((wordfrequency)/((float)totalfrequency));
          /*sprintf((char*)text, "percent=%f", prct);
          lcd.DisplayStringAt(0, LINE(num), (uint8_t *)&text, LEFT_MODE);*/
          prct = 0;
          wordfrequency = 0;
          num = num + 2;
        }
        wait(1);
    }
}
