    AREA PROGRAM4, CODE, READONLY
    
    GLOBAL CountItems
    ;int32_t CountItems()
    
CountItems ; get max num of words
    MOV R0, #0 ; track num of words 
    LDR R1,= table ; get address of beginning of table
    MOV R3, #14 ; use to move to next word in table
    LDR R2, [R1, R3] ; move R3 num of bytes in the table 
    B getWordCount
    
getWordCount
    CMP R2, #0 ; compare value in table to 0
    BEQ leave1 
    ADD R0, R0, #1 ; add 1 to num of words
    LDR R2, [R1, R3] ; move R3 num of bytes in the table 
    ADD R3, R3, #14 ; add 14 bytes to R3
    B getWordCount ; loop back

leave1 
    BX LR

    GLOBAL SumAllFrequencies
    ;int32_t SumAllFrequencies()

SumAllFrequencies
    MOV R4, #0 ; track frequency num
    LDR R1,= table ; get address of beginning of table
    MOV R3, #12 ; use 12 to account for word being first in table
    B getFrequencyCount

getFrequencyCount
    CMP R2, #0 ; compare value in table to 0
    BEQ leave ; break because looped through entire table
    LDRH R2, [R1, R3] ; move R3 num of bytes in the table
    ADD R4, R4, R2 ; add current frequency to total frequency
    ADD R3, R3, #14 ; add 14 bytes to R3
    B getFrequencyCount ; loop back
    
leave
    MOV R0, R4
    BX LR

    GLOBAL GetWordAt
    ;uint8_t * GetWordAt(int32_t i)

GetWordAt
    MOV R1, #1
    ADR R2, table ; get address of beginning of table
    LDR R3, [R2] ; get value at address of beginning of table
    MOV R4, #14 ; use to move to next word in table
    B findWord
    
findWord
    CMP R1, R0 ; compare 1 to i
    BEQ wordFound ; break because word found
    LDR R3, [R2, R4] ; move R4 num of bytes in table
    ADD R4, R4, #14 ; add 14 bytes to R3
    ADD R1, R1, #1
    B findWord
    
wordFound
    MOV R0, R3
    BX LR

    GLOBAL GetFreqAt
    ;int16_t GetFreqAt(int32_t i)
    
GetFreqAt
    MOV R1, #1
    LDR R2,= table ; get address of beginning of table
    MOV R3, #12 ; use 8 to account for word being first in table
    LDRH R4, [R2, R3] ; get value where first frequency is stored in table
    ADD R3, R3, #14 ; use to move to next frequency in table
    B findFrequency
    
findFrequency
    CMP R1, R0 ; compare R1 to i
    BEQ frequencyFound ; break because frequency found
    LDRH R4, [R2, R3] ; move R3 num of bytes in table
    ADD R3, R3, #14 ; add 12 bytes to R3
    ADD R1, R1, #1
    B findFrequency
    
frequencyFound
    MOV R0, R4
    BX LR

            ALIGN
table       DCB "pie",0
            SPACE 8
            DCW 34
            
            DCB "cake",0
            SPACE 7
            DCW 29
            
            DCB "souffle",0
            SPACE 4
            DCW 22
            
            DCB "cookie",0
            SPACE 5
            DCW 15
            
            DCB 0

    END