#include "mbed.h"
#include "leds.h"
#include "timers.h"

Serial pc(USBTX, USBRX); // tx, rx

TIMER0_INTERRUPT_HANDLER(void)
{
    TIMER0_CLEAR_INTERRUPT(MR0_INT);
    LPC_TIM1->TC++;
    static int i = 0;
    i++;
    if(i%2)
        LEDS_SET(LED1);
    else
        LEDS_SET(LED2);
}

int main() {
    LEDS_INIT();
    TIMER0_INIT();
    TIMER0_SETPCLK(CCLK);
    TIMER0_SETPRESCALE(96); // 1ms
    TIMER0_SETMATCH(0, 1000000);
    TIMER0_SETMATCHCONTROL(0, MATCH_RESET | MATCH_INTERRUPT); // Reset and Interrupt each 100ms
    TIMER0_ENABLE_INTERRUPT();
    TIMER0_START();
    pc.printf("CCLK: %d", CCLK);
    
    int t = 0;
    while (1) {
        t = TIMER0_VALUE();
        //pc.printf("TIMER: %d - %d", LPC_TIM1->TC, t);
        pc.printf("%d\n", LPC_TIM1->TC);
        wait(1);
    }
}
