#include "mbed.h"
/************************************************************
*   Very quick test program to test LPC1768 interface to 
*   25AA080A Microchip SPI 8k EEPROM 
*
*   Note: nothing fancy
*
************************************************************/
Serial pc(USBTX, USBRX); // tx, rx
 
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);
 
int main() {
    uint8_t ret_val = 0;

    // Chip must be deselected
    cs = 1;

    // second edge capture, with a 1MHz clock rate
    spi.format(8,0);
    spi.frequency(1000000);
 
    // Select the device by seting chip select low
    cs = 0;
    
    /*write some known data to EEPROM 
     * Set the WREN latch instruction first
     */
    spi.write(0x06);
    cs = 1;
    wait(0.001);
    cs = 0;
    spi.write(0x02); 
    spi.write(0x00);
    spi.write(0x01); //memory location 0x0001
    
    for (uint8_t i=0; i<15; i++)
        {
            spi.write(i);  //Can only write 16bytes in single write instruction
            pc.printf("Writing = 0x%X \t %d\n\r", i, i);
            wait(0.001);   //probably not be needed as is only writing to a buffer
        }
    cs = 1; // Must deselect for the write operation to complete
 
    wait(2); //Need some delay between write and read
    
    cs = 0;
 
    spi.write(0x03);
    spi.write(0x00);
    for (int i=0; i<32; i++)
        {
            ret_val = spi.write(0x01); // The address will increment on each read from here
            pc.printf("Reading = 0x%X \t %d\n\r", ret_val, ret_val);
            wait(0.2);
        }
    
        // Deselect the device
    cs = 1;
    


}