#include "mbed.h"
Mutex mutex;
ConditionVariable cond(mutex); 
const int size = 3;
int numberOfItems = 0;

typedef struct{
    int number;
}message_t;
MemoryPool<message_t, size> mpool;
Queue<message_t, size> queue;

void consumer(){
     while(true){
        wait(rand() % 3);
        mutex.lock();
        if(numberOfItems > 0){
            osEvent evt = queue.get();
            message_t *message = (message_t*)evt.value.p;
            printf("number %d consumed", message->number);
            numberOfItems--;
            printf("Consumer. there are %d elements in queue\n", numberOfItems);
            mpool.free(message);
        }else{
            printf("Consumer. queue is empty\n");
        }
        cond.notify_all();
        mutex.unlock();
    }
}


int main() {
    Thread thread;
    thread.start(consumer);

    //Producer
    while(true){
        wait(rand() % 3);
        mutex.lock();
        if(numberOfItems < size){
            message_t *message = mpool.alloc();
            message->number = rand();
            queue.put(message);
            numberOfItems++;
            printf("Producer. there are %d elements in queue\n", numberOfItems);
        }else{
            printf("Producer. queue full\n");
        }
        cond.notify_all();
        mutex.unlock();
    }   
}