#include "mbed.h"

// Sensors drivers present in the BSP library
#include "stm32l475e_iot01_tsensor.h"
#include "stm32l475e_iot01_hsensor.h"
#include "stm32l475e_iot01_psensor.h"
#include "stm32l475e_iot01_magneto.h"
#include "stm32l475e_iot01_gyro.h"
#include "stm32l475e_iot01_accelero.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int main()
{
    int16_t pDataXYZ[3] = {0};
    BSP_ACCELERO_Init();
    led1 = 0;
    led2 = 0;
    led3 = 0;

    while(1) {
        int x = abs(pDataXYZ[0]);
        int y = abs(pDataXYZ[1]);
        int z = abs(pDataXYZ[2]);
        //100 of tollerance.
        
        if(z > 950 && z < 1050){
            led1 = 0;
            led2 = 0;
            led3 = 0;
            wait(0.5);
            led1 = 1;
            led2 = 0;
            led3 = 0;
        } else if(y > 950 && y < 1050){
            led1 = 0;
            led2 = 0;
            led3 = 0;
            wait(0.5);
            led1 = 0;
            led2 = 1;
            led3 = 0;   
        }else if(x > 950 && x < 1050){
            led1 = 0;
            led2 = 0;
            led3 = 0;
            wait(0.5);
            led1 = 0;
            led2 = 0;
            led3 = 1;   
        }else{
            led1 = 0;
            led2 = 0;
            led3 = 0;
            wait(0.5);
            led1 = 1;
            led2 = 1;
            led3 = 1;  
        }
        
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        printf("\nACCELERO_X = %d\n", x);
        printf("ACCELERO_Y = %d\n", y);
        printf("ACCELERO_Z = %d\n", z);

    }
}
