#include "mbed.h"

DigitalOut led1(LED1);
InterruptIn button(USER_BUTTON);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;
volatile static time_t begin;
volatile static int pressCount = 0;

void blinkLed1(void){
    led1 = 1;
    wait(0.5);
    led1 = 0;
}

void rise_handler_thread_context(void) {
    printf("Button pressed. count = %d\n", pressCount);
    if(pressCount == 1){
        begin = time(NULL);
    }else{
        pressCount = 0;
        if(time(NULL) - begin < 2){
            printf("Blinking");
            blinkLed1();
        }
    }
}

void rise_handler_iterrupt_context(void) {
    pressCount += 1;
    queue.call(rise_handler_thread_context);
}

int main() {
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Starting in context %p\r\n", Thread::gettid());
    // The 'rise' handler will execute in IRQ context
    button.rise(rise_handler_iterrupt_context);
}
