
#include "mbed.h"
#include <stdio.h>
#include <errno.h>

// Block devices
#if COMPONENT_SPIF
#include "SPIFBlockDevice.h"
#endif

#if COMPONENT_DATAFLASH
#include "DataFlashBlockDevice.h"
#endif 

#if COMPONENT_SD
#include "SDBlockDevice.h"
#endif 

#include "HeapBlockDevice.h"

// File systems
#include "LittleFileSystem.h"
#include "FATFileSystem.h"

#include "stm32l475e_iot01_accelero.h"

// Physical block device, can be any device that supports the BlockDevice API
/*SPIFBlockDevice bd(
        MBED_CONF_SPIF_DRIVER_SPI_MOSI,
        MBED_CONF_SPIF_DRIVER_SPI_MISO,
        MBED_CONF_SPIF_DRIVER_SPI_CLK,
        MBED_CONF_SPIF_DRIVER_SPI_CS);*/

#define BLOCK_SIZE 512
HeapBlockDevice bd(4096, BLOCK_SIZE);

// File system declaration
LittleFileSystem fs("fs");

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

// Set up the button to trigger an erase
InterruptIn irq(BUTTON1);
void erase() {
    printf("Initializing the block device... ");
    fflush(stdout);
    int err = bd.init();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Erasing the block device... ");
    fflush(stdout);
    err = bd.erase(0, bd.size());
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Deinitializing the block device... ");
    fflush(stdout);
    err = bd.deinit();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }
}


// Entry point for the example

Ticker toggle_write_to_file;
EventQueue queue(16 * EVENTS_EVENT_SIZE);
Thread t;
static FILE *f;
volatile int counter = 0;
time_t begin = time(NULL);



void writeAccToFile(){
    int16_t pDataXYZ[3] = {0};
    BSP_ACCELERO_AccGetXYZ(pDataXYZ);
    int x = abs(pDataXYZ[0]);
    int y = abs(pDataXYZ[1]);
    int z = abs(pDataXYZ[2]);
    char c;
    if(z > 950 && z < 1050){
        c = 'z';
    } else if(y > 950 && y < 1050){
        c = 'y'; 
    }else if(x > 950 && x < 1050){
        c = 'x';   
    }else{
        c = 'o';
    }
    fprintf(f, "%c", c);
    fflush(stdout); 
}

void readAccFile(){
    printf("end sampling \n");
    
    // Close the file which also flushes any cached writes
    printf("Closing \"/fs/numbers.txt\"... ");
    fflush(stdout);
    int err = fclose(f);
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }
    
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    f = fopen("/fs/numbers.txt", "r");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }
    
    int xCount = 0;
    int yCount = 0;
    int zCount = 0;
    
    while (!feof(f)) {
        char c = fgetc(f);
        if(c == 'x'){
            xCount++;
        }else if(c == 'y'){
            yCount++;
        }else if(c == 'z'){
            zCount++;
        }
    }
    printf("Values: x: %d, y:%d, z: %d \n", xCount, yCount, zCount);
    
    //Switch on the LED. x is default Led.
    if(xCount >= yCount && xCount >= zCount){
        led3 = 1;
    }else if(yCount > xCount && yCount > zCount){
        led2 = 1;
    }else{
        led1 = 1;
    }

    printf("\rClosing \"/fs/numbers.txt\"... ");
    fflush(stdout);
    err = fclose(f);
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    // Tidy up
    printf("Unmounting... ");
    fflush(stdout);
    err = fs.unmount();
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(-err), err);
    } 
    printf("Mbed OS filesystem example done!\n");
    
}

void readSensorsInterupt() {
    queue.call(writeAccToFile);
    counter++;
    if (counter == 1000) {
      toggle_write_to_file.detach();
      queue.call(readAccFile);
    }
}

int main() {
    // Setup the erase event on button press, use the event queue
    // to avoid running in interrupt context
    irq.fall(mbed_event_queue()->event(erase));

    // Try to mount the filesystem
    printf("Mounting the filesystem... ");
    fflush(stdout);
    int err = fs.mount(&bd);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("No filesystem found, formatting... ");
        fflush(stdout);
        err = fs.reformat(&bd);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }

    // Open the numbers file
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    f = fopen("/fs/numbers.txt", "r +");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        // Create the numbers file if it doesn't exist
        printf("No file found, creating a new file... ");
        fflush(stdout);
        f = fopen("/fs/numbers.txt", "w+");
        printf("%s\n", (!f ? "Fail :(" : "OK"));
        if (!f) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
        
        printf("Seeking file... ");
        fflush(stdout);
        err = fseek(f, 0, SEEK_SET);
        printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
        if (err < 0) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
    }
    
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    BSP_ACCELERO_Init();
    led1 = 0;
    led2 = 0;
    led3 = 0;
    printf("Start sampling... \n");
    begin = time(NULL);
    toggle_write_to_file.attach(&readSensorsInterupt, 0.01);
}












