#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
#include "string.h"
#include <Pulse1.h>

PulseInOut irda(PTB0);// Pin para la entrada de datos del sensor infrarrojo
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); 
Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTA16, PTA17, NC, 48);
DebouncedIn button_enco(PTC5);
DigitalOut myled(LED3);

int numN[35];
int numP[35];
int numbin[35];
int bin[35];
int dato; 
int pul_low;
int i1,j1,k1,header,proL,proH; 
char r;
char cadena[33];
char uno[33]="11100000111000000010000011011111";  //ya
char dos[33]="11100000111000001010000001011111";  //ya
char tres[33]="11100000111000000110000010011111";  //ya
char cuatro[33]="11100000111000000001000011101111";
char cinco[33]="11100000111000001001000001101111";
char seis[33]="11100000111000000101000010101111";  //ya
char siete[33]="11100000111000000011000011001111";
char set[33]="11100000111000000001011011101001";
int mode=0;
int code;
int numb=32;
int s=0;
//
int C1=0x0C;
int m;
int Conf=0;  // selector alarma u hora
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int j=1;
int IRDA=1;
int irda_en=0;
int visual=0;
int alarma=0;
int main()
{
    myled=1;
    j=1;
    Rtc_Ds1307::Time_rtc tm2 = {};
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc Alarm[8] = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("--Alarmas --Hora"); 
    rtc.getTime(tm); //lee los datos del DS1307

    while(1)
    {
        
        switch (Lugar)
        {
            case 0:
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                
                if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                
                if(Conf==0){
                    
                    lcd.locate(11,0);
                    lcd.printf("-");                    
                    lcd.locate(1,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                    
                }
                
                 if(Conf==1){
                    
                    lcd.locate(1,0);
                    lcd.printf("-");                    
                    lcd.locate(11,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                }
                
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            
            break;
            
            case 1:
                switch(i)
                {
                    case 0:                     
                        if(Conf==0) // ALARMA
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Poner Alarmas ");
                            wait(1);
                            lcd.cls();
                            i++;
                            lcd.locate(0,0);
                            lcd.printf("dia: ");
                            m=0;                             
                        }
                
                        if(Conf==1) //RELOJ
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Poner Hora   ");
                            wait(1);
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("dia: ");
                            m=0;
                            
                        }    

                    break;
                    
                    case 1: //configuramos los dias de la semana
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.wday=tm.wday+m;
                            if(tm.wday>7)
                            {
                                tm.wday=1;
                            }
                            if(tm.wday<1)
                            {
                                tm.wday=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        
                        switch(tm.wday){
                            case (1):
                                lcd.locate(5,0);
                                lcd.printf("domingo    ");
                            break;    
                            case (2):
                                lcd.locate(5,0);
                                lcd.printf("lunes   ");
                            break;     
                            case (3):
                                lcd.locate(5,0);
                                lcd.printf("martes   ");
                            break;     
                            case (4):
                                lcd.locate(5,0);
                                lcd.printf("miercoles");
                            break;                                        
                            case (5):
                                lcd.locate(5,0);
                                lcd.printf("jueves ");
                            break;     
                            case (6):
                                lcd.locate(5,0);
                                lcd.printf("viernes   ");
                            break;     
                            case (7):
                                lcd.locate(5,0);
                                lcd.printf("sabado ");
                            break;                                    
                            }  
                        
                        
                        if (button_enco.falling())
                        {
                            switch(Conf)
                            {
                                case 0:
                                    i=5;
                                    m=0;
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("hora: ");
                                    m=0;
                                break;    
                                case 1:
                                    i=2;
                                    m=0;
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("dia: ");
                                break;
                            }           
                        }
                    
                    break;
                    case 2: // configuramos fecha
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.date=tm.date+m;
                            if(tm.date>31)
                            {
                                tm.date=0;
                            }
                            if(tm.date<1)
                            {
                                tm.date=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d   ",tm.date);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("mes: ");
                            
                        }
                    break;
                    case 3: // configuramos mes
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.mon=tm.mon+m;
                            if(tm.mon>12)
                            {
                                tm.mon=0;
                            }
                            if(tm.mon<1)
                            {
                                tm.mon=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(7,0);
                        lcd.printf("%02d",tm.mon);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("anio: ");
                            
                        }
                    
                    break;
                    
                    case 4: //configuramos año
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.year=tm.year+m;
                             if(tm.year>2100)
                            {
                                tm.mon=0;
                            }
                            if(tm.year<2017)
                            {
                                tm.year=2017;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.year);
                        
                        if (button_enco.falling())
                        {
                            i=5;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("hora: ");
                            
                            
                        }
                    
                    break;
                    
                    case 5: //configuramos hora
                        m=0;
                        m=wheel.getPulses();       
                        if (m!=0) 
                        {
                            tm.hour+= m;
                            if(tm.hour>23)
                            {
                                tm.hour=0;
                            }
                            
                            if(tm.hour<0)
                            {
                                tm.hour=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.hour);
                        
                        if (button_enco.falling())
                        {
                            i=6;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("min: ");
                            //tm.min=0;
                        }
                    
                    break;
                    
                    case 6: //configuramos minutos
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.min=tm.min+m;
                            if(tm.min>59)
                            {
                                tm.min=0;
                            }
                            if(tm.min<0)
                            {
                                tm.min=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.min);
                        
                        if (button_enco.falling())
                        {
                            i=7;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("seg: ");
                            //tm.sec=0;
                        }
                    
                    break;
                    
                    
                    case 7: //configuramos los segundos
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.sec=tm.sec+m;
                            if(tm.sec>59)
                            {
                                tm.sec=0;
                            }
                            if(tm.sec<0)
                            {
                                tm.sec=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.sec);
                        
                        if (button_enco.falling())
                        {
                           
                            if(Conf==0)
                            {
                                Alarm[j]=tm;
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Alarma %d lista ",j);
                                wait(1);
                                i=0;
                                m=0;
                                if(j>=7)
                                {
                                Lugar++;
                                }
                                j++;
                                lcd.cls();
                                                          
                            }
                
                            if(Conf==1)
                            {   
                                rtc.setTime(tm, true, false);
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Hora lista  ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar=0;
                                lcd.locate(0,0);
                                lcd.printf("--Alarmas --Hora");                                
                            } 
                           
                         
                        }
                    
                    break;
                   
                }            
            break;
            
            case 2: // comprobamos el estado de la alarma
                rtc.getTime(tm2); 
                
                           
                if(visual==0)
                {    
                    lcd.locate(0,0);                        
                    lcd.printf("Hora:   ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",tm2.hour);
                    lcd.printf("%02d:",tm2.min);
                    lcd.printf("%02d",tm2.sec); 
                    lcd.locate(0,1);
                    switch(tm2.wday){
                            case (1):
                                lcd.locate(0,1);
                                lcd.printf("D   ");
                            break;    
                            case (2):
                                lcd.locate(0,1);
                                lcd.printf("L   ");
                            break;     
                            case (3):
                                lcd.locate(0,1);
                                lcd.printf("M   ");
                            break;     
                            case (4):
                                lcd.locate(0,1);
                                lcd.printf("M   ");
                            break;                                        
                            case (5):
                                lcd.locate(0,1);
                                lcd.printf("J   ");
                            break;     
                            case (6):
                                lcd.locate(0,1);
                                lcd.printf("V   ");
                            break;     
                            case (7):
                                lcd.locate(0,1);
                                lcd.printf("S   ");
                            break;                                    
                    }
                    lcd.locate(6,1);          
                    lcd.printf("%02d/",tm2.date);
                    lcd.printf("%02d/",tm2.mon);
                    lcd.printf("%02d",tm2.year);
                    wait(0.1);
                  
                    m=wheel.getPulses();
                    if(m!=0)
                    {
                        visual=1;
                        wheel.reset();  
                        m=0;
                    }
                }
                
                if(visual==1)
                {
                    lcd.locate(0,1);    
                    lcd.printf("     ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",Alarm[IRDA].hour);
                    lcd.printf("%02d:",Alarm[IRDA].min);
                    lcd.printf("%02d",Alarm[IRDA].sec);
                    
                    switch(Alarm[IRDA].wday){
                            case (1):
                                lcd.locate(0,0);
                                lcd.printf("D     ");
                            break;    
                            case (2):
                                lcd.locate(0,0);
                                lcd.printf("L     ");
                            break;     
                            case (3):
                                lcd.locate(0,0);
                                lcd.printf("M     ");
                            break;     
                            case (4):
                                lcd.locate(0,0);
                                lcd.printf("M     ");
                            break;                                        
                            case (5):
                                lcd.locate(0,0);
                                lcd.printf("J     ");
                            break;     
                            case (6):
                                lcd.locate(0,0);
                                lcd.printf("V     ");
                            break;     
                            case (7):
                                lcd.locate(0,0);
                                lcd.printf("S     ");
                            break;                                    
                    }
                    lcd.locate(5,1);
                    lcd.printf("Alarma %d",IRDA);    
                    wait(0.1);
                    ////
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        visual=0;
                        wheel.reset();  
                        m=0;                                       
                    }
                }
//Comprobación de la alarma              
                if( (tm2.wday==Alarm[IRDA].wday)&&((tm2.hour)==Alarm[IRDA].hour)&&(tm2.min==Alarm[IRDA].min)&&(tm2.sec==Alarm[IRDA].sec) )
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma Sonando");
                    wait(1);
                    lcd.locate(0,0);
                    lcd.printf("->Apagar     ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Posponer     ");
                    m=0;
                }
//configuración infrarrojo               
                if (button_enco.falling())
                        {
                            irda_en=1;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("  Senal  ");
                            
                        }
                 
            break;
            
            case 3: //Posponer
                
                if(alarma==0) 
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=1;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf("-");                    
                        lcd.locate(1,1);
                        lcd.printf(">");                                          
                    }
                }
                          
             
                
                if(alarma==1) //Apagar
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=0;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf(">");                    
                        lcd.locate(1,1);
                        lcd.printf("-");                                          
                    }
                }
                
                if (button_enco.falling())
                {
                    if(alarma==0)
                    {
                        Lugar=2; //regresamos al lugar del reloj
                        wheel.reset();
                        m=0;
                        myled=1;
                        lcd.cls();                          
                    }
                    if(alarma==1)
                    {
                        Lugar=2;  //regresamos al lugar de configuracion de alarma
                        rtc.getTime(tm2);
                        if(tm.min!=58)
                        {
                            Alarm[IRDA].min=tm2.min+1;
                        }
                        if(tm.min==59)
                        {
                            Alarm[IRDA].min=0;
                            Alarm[IRDA].hour=tm2.hour+1;
                        }
                        Alarm[IRDA].sec=tm2.sec;
                        lcd.cls();
                        alarma=0;
                        myled=1;   
                    }                    
                }
            break;
        }
// lecturas del infrarrojo              
        while (irda_en)
        {
        fflush( stdin );     
        lop2:  if(!mode){
               header = irda.read_high_us(); 
               if(header>3500) goto seguir2;
               goto lop2;
               }
                  
        seguir2:
              for(i1=0;i1<numb;++i1){  
              numP[i1] = irda.read_high_us();    //funcion para leer un pulso alto
              if (numP[i1]<1000){
                s=0;
                r='0';
              }else{
                s=1;
                r='1';
              }
              numbin[i1]=s;
              cadena[i1]=r;                                    
              }
              if (!strcmp(cadena,uno)){
              IRDA=1;    
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,dos)){
              IRDA=2;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,tres)){
              IRDA=3;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,cuatro)){
              IRDA=4;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,cinco)){
              IRDA=5;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,seis)){
              IRDA=6;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;
              }else if (!strcmp(cadena,siete)){
              IRDA=7;
              lcd.locate(8,1);
              lcd.printf("%d",IRDA);
              goto seguir2;   
              }else if(!strcmp(cadena,set)){
              goto lop3;   
              }    
        lop3: Lugar=2;
              irda_en=0;
              lcd.cls();
              break;  
        }
    }          
}