#include "mbed.h"
#include "Ograda.h"


Ograda motor(D2,D3,D4,D5);
InterruptIn endsw_close(D6, PullDown);
InterruptIn endsw_open(D7, PullDown);
InterruptIn signal_start(USER_BUTTON, PullDown);
int pom=0;

Serial pc(USBTX, USBRX);
Timer debounce;

void ispis()
{
    pc.printf("Ograda je zatvorena = 1, Ograda nije zatvorena = 0: %d \n \r ", endsw_close.read());
    pc.printf("Ograda je otvorena = 1,  Ograda nije otvorena= 0: %d \n  \n\r ", endsw_open.read());
}

void ograda_stop()
{
    debounce.start();
    if (debounce.read_ms()>200)
    {
        motor.stop();
        pc.printf("Zaustavaljanje ograde \n \r ");
        pom=1;         //služi za povratak u glavnu funkciju
        ispis();        //ispis ulaza 
        debounce.reset();
    }
}

void ograda_otvori()  // procedura otvaranja ograde - senzor pri otvaranju smeta
{
    motor.start(1, 0.0);
    pc.printf("Otvaranje ograde \n  \n \r ");
    ispis();
}


void glavna() // funkcija provjere stanja ulaza koja se izvodi kod svakog novog događaja
{
    if(endsw_close.read()==0 && endsw_open.read()==0)
    {
        pc.printf("Zatvaranje ograde za 10s \n \n \r ");
        wait(10);
        motor.start(0, 2.0);
        pc.printf("Zatvaranje ograde \n \n \r ");
        ispis();
    }
    
    
    pom=0;
    signal_start.rise(NULL); //blokiranje signala iz daljinskog uptavljača ukoliko ograda nije zatvorena
 
    if(endsw_close.read()==0 && endsw_open.read()==1) 
    {

        pc.printf("Zatvaranje ograde za 10s \n \n \r ");
        wait(10);
        motor.start(0, 2.0);
        pc.printf("Zatvaranje ograde \n \n \r ");
        ispis();
    }
 
 
    if(endsw_close.read()==1) 
    {
        signal_start.rise(&ograda_otvori);
        pc.printf("Pritisni start za otvaranje ograde  \n\n \r ");
        ispis();
    }
}

int main()
{
    ispis();
    signal_start.rise(NULL); // signal za otvaranje ograde nije potreban ukoliko ograda nije zatvorena
    endsw_close.rise(&ograda_stop);
    endsw_open.rise(&ograda_stop); //definiranje događaja prilikom rastućih bridova
 
    glavna();
 
    while(1) {
      
        if(endsw_close.read()==1 && endsw_open.read()==1) // provjera jesu li prekidači u kratkom spoju
        
        { 
            pc.printf("Krjanji prekidaci nisu ispravni  \n\n \r ");
            ograda_stop();
            break;
        }
 
 
        if(pom==1) 
        {
            glavna();
        }
    }
}

