#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include "MTSText.h"
#include "RadioEvent.h"
#include "ChannelPlans.h"
#include <string>
#include <vector>

#define PEER_TO_PEER_SAMPLE 1
 //#define OTA
using namespace mts;
#if defined(PEER_TO_PEER_SAMPLE)
static uint8_t network_address[] = { 0x01, 0x02, 0x03, 0x04 };
static uint8_t network_session_key[] = { 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04 };
static uint8_t data_session_key[] = { 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04 };
#else

static std::string config_network_name = "conduitUNSAM";
static std::string config_network_pass = "conduitUNSAM";
static uint8_t config_frequency_sub_band = 4;
#endif

mDot* dot;
lora::ChannelPlan* plan = NULL;

void update_peer_to_peer_config(uint8_t *network_address, uint8_t *network_session_key, uint8_t *data_session_key, uint32_t tx_frequency, uint8_t tx_datarate, uint8_t tx_power) {
    std::vector<uint8_t> current_network_address = dot->getNetworkAddress();
    std::vector<uint8_t> current_network_session_key = dot->getNetworkSessionKey();
    std::vector<uint8_t> current_data_session_key = dot->getDataSessionKey();
    uint32_t current_tx_frequency = dot->getTxFrequency();
    uint8_t current_tx_datarate = dot->getTxDataRate();
    uint8_t current_tx_power = dot->getTxPower();

    std::vector<uint8_t> network_address_vector(network_address, network_address + 4);
    std::vector<uint8_t> network_session_key_vector(network_session_key, network_session_key + 16);
    std::vector<uint8_t> data_session_key_vector(data_session_key, data_session_key + 16);

    if (current_network_address != network_address_vector) {
        logInfo("changing network address from \"%s\" to \"%s\"", mts::Text::bin2hexString(current_network_address).c_str(), mts::Text::bin2hexString(network_address_vector).c_str());
        if (dot->setNetworkAddress(network_address_vector) != mDot::MDOT_OK) {
            logError("failed to set network address to \"%s\"", mts::Text::bin2hexString(network_address_vector).c_str());
        }
    }
    
    if (current_network_session_key != network_session_key_vector) {
        logInfo("changing network session key from \"%s\" to \"%s\"", mts::Text::bin2hexString(current_network_session_key).c_str(), mts::Text::bin2hexString(network_session_key_vector).c_str());
        if (dot->setNetworkSessionKey(network_session_key_vector) != mDot::MDOT_OK) {
            logError("failed to set network session key to \"%s\"", mts::Text::bin2hexString(network_session_key_vector).c_str());
        }
    }
    
    if (current_data_session_key != data_session_key_vector) {
        logInfo("changing data session key from \"%s\" to \"%s\"", mts::Text::bin2hexString(current_data_session_key).c_str(), mts::Text::bin2hexString(data_session_key_vector).c_str());
        if (dot->setDataSessionKey(data_session_key_vector) != mDot::MDOT_OK) {
            logError("failed to set data session key to \"%s\"", mts::Text::bin2hexString(data_session_key_vector).c_str());
        }
    }
    
    if (current_tx_frequency != tx_frequency) {
    logInfo("changing TX frequency from %lu to %lu", current_tx_frequency, tx_frequency);
    if (dot->setTxFrequency(tx_frequency) != mDot::MDOT_OK) {
        logError("failed to set TX frequency to %lu", tx_frequency);
    }
    }

    if (current_tx_datarate != tx_datarate) {
    logInfo("changing TX datarate from %u to %u", current_tx_datarate, tx_datarate);
    if (dot->setTxDataRate(tx_datarate) != mDot::MDOT_OK) {
        logError("failed to set TX datarate to %u", tx_datarate);
    }
    }

    if (current_tx_power != tx_power) {
    logInfo("changing TX power from %u to %u", current_tx_power, tx_power);
    if (dot->setTxPower(tx_power) != mDot::MDOT_OK) {
        logError("failed to set TX power to %u", tx_power);
    }
    }
}

int main() {
    Serial debug(USBTX, USBRX);
    debug.baud(115200);
    
    RadioEvent events;
    
    int32_t ret;
    int32_t next_tx;
    int32_t wait_time = 2;
    
    std::vector<uint8_t> send_data;
    std::vector<uint8_t> recv_data;
    uint8_t recv = 0;
    uint8_t recv_mismatch = 0;
    uint8_t send_failure = 0;
    uint8_t iterations = 5;
    
    send_data.push_back(0x00);
    send_data.push_back('N');
    send_data.push_back('A');
    send_data.push_back('T');
    send_data.push_back('I');
    send_data.push_back(' ');
    send_data.push_back(' ');
    send_data.push_back(' ');
    
    plan = new lora::ChannelPlan_US915();

    dot = mDot::getInstance(plan);
    logInfo("defaulting Dot configuration");
    dot->resetConfig();
    //si se hace un deep sleep la aplicacion inicia desde el principio.
    //Y no desde el punto donde se ejecuto el deep_sleep
    //Por esto es necesario salvar la sesion y luego recuperarla para continuar trabajando
    //dot->resetNetworkSession();
    //dot->restoreNetworkSession();
    //dot->saveNetworkSession();
    dot->setLogLevel(MTSLog::INFO_LEVEL);
    
 #if defined(PEER_TO_PEER_SAMPLE)
    // attach the custom events handler
     dot->setEvents(&events);
    
    //Peer-to-peer    
    // Actualizamos la configuracion de Join unicamente si es diferente 
     //( 0= Manual, 1 = OTA, 2= AUTO_OTA, 3=Peer to Peer)
    if (dot->getJoinMode() != mDot::PEER_TO_PEER) {
        logInfo("changing network join mode to PEER_TO_PEER");
        if (dot->setJoinMode(mDot::PEER_TO_PEER) != mDot::MDOT_OK) {
            logError("failed to set network join mode to PEER_TO_PEER");
        }
    }
    uint32_t tx_frequency= 915500000;
    uint8_t tx_datarate = lora::DR_13;
    uint8_t tx_power = 20;
    
    update_peer_to_peer_config(network_address, network_session_key, data_session_key, tx_frequency, tx_datarate, tx_power);

 #else
    // Actualizamos la configuracion de Join unicamente si es diferente 
    //( 0= Manual, 1 = OTA, 2= AUTO_OTA, 3=Peer to Peer)
    if (dot->getJoinMode() != mDot::AUTO_OTA) {
        logInfo("changing network join mode to AUTO_OTA");
        if (dot->setJoinMode(mDot::AUTO_OTA) != mDot::MDOT_OK) {
            logError("failed to set network join mode to AUTO_OTA");
        }
    }
    while ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
        logError("failed to set frequency sub band: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
    }
    while ((ret = dot->setNetworkName(config_network_name)) != mDot::MDOT_OK) {
        logError("failed to set network name: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
    }
    while ((ret = dot->setNetworkPassphrase(config_network_pass)) != mDot::MDOT_OK) {
        logError("failed to set network password: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
    }
    while ((ret = dot->setPublicNetwork(1)) != mDot::MDOT_OK) {
        logError("failed to set public network : [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
 #endif
        
    // save changes to configuration
    logInfo("saving configuration");
    if (!dot->saveConfig()) {
        logError("failed to save configuration");
    }
    
    //logInfo("enabling activity LED");
    dot->setActivityLedEnable(true);
 
    logInfo("joining network");
    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
        logError("failed to join network: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
        wait_ms(dot->getNextTxMs() + 1);
    }
    logInfo("joined");
 
    while(1) {
        std::string rxxdata = events.print();
        next_tx = dot->getNextTxMs() + 1;
        logInfo("Datos : %s", rxxdata);
        wait_ms(5000);
        logInfo("waiting data \n");
        wait_ms(100);
    }
    
    logInfo("Version: %s", dot->getId().c_str());
    logInfo("Recv: %d/%d", recv, iterations);
    logInfo("Recv Mismatch: %d/%d", recv_mismatch, iterations);
    logInfo("Send Failure: %d/%d", send_failure, iterations);
    logInfo("Dropped: %d/%d", iterations - (recv + recv_mismatch + send_failure), iterations);
 
    return 0;
}
