#ifndef __RADIO_EVENT_H__
#define __RADIO_EVENT_H__

#include "mDotEvent.h"

class RadioEvent : public mDotEvent
{
 
public:
    RadioEvent() {}
 
    virtual ~RadioEvent() {}
    
    std::string buffer;
 
    virtual void MacEvent(LoRaMacEventFlags* flags, LoRaMacEventInfo* info) {
        if (flags->Bits.Rx) {
 
            if (info->RxBufferSize > 0) {
                // print RX data as string and hexadecimal 
                std::string rx((const char*)info->RxBuffer, info->RxBufferSize);
                printf("Rx data: %s [%s]\r\n", rx.c_str(), mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str());
                buffer += rx;
            }
        }
    }
    
    string print(){
        std::string pepe;
        pepe = buffer;
        buffer = "";
        return(pepe);    
    }
        
    
};

#endif

