#include "mbed.h"
#include <sstream>
#include "rtos.h"
Serial pc(USBTX, USBRX);
Serial esp(p13, p14); // tx, rx
DigitalOut reset(p16);
Timer t;
 
int  count,ended,timeout;
char buf[2024];
char snd[1024];
 
char ssid[32] = "iPhone";     // enter WiFi router ssid inside the quotes
char pwd [32] = "ece-4180"; // enter WiFi router password inside the quotes
 
void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate();
 void dev_recv()
{
    while(esp.readable()) {
        pc.putc(esp.getc());
    }
}
 
void pc_recv()
{
    while(pc.readable()) {
        esp.putc(pc.getc());
    }
}
 
// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}
 
//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{
    reset=0; //hardware reset for 8266
    pc.baud(9600);  // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------ESP8266 Hardware Reset-------------\n\r");
    wait(5);
    reset=1;
    timeout=2;
    wait(5);
    pc.printf("\f---------- Starting ESP Config ----------\r\n\n");
        strcpy(snd,".\r\n.\r\n");
    SendCMD();
        wait(1);
    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"node.restart()\r\n");
    SendCMD();
    timeout=5;
//    getreply();
//    pc.printf(buf);
 
    wait(2);
    
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "wifi.setmode(wifi.STATION)\r\n");
    SendCMD();
//    timeout=4;
//    getreply();
    pc.printf(buf);

    wait(2);
 
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "wifi.sta.config(\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\")\r\n");
    SendCMD();
    timeout=10;
//    getreply();
//    pc.printf(buf);
// 
    wait(5);
 
    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "print(wifi.sta.status())\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    wait(1);
}

void sendData(int temp, int heartRate){
        
////    pc.printf("\n---------- Sending Data ----------\r\n");
//    
    std::ostringstream getRequest;
    getRequest << "conn:send(\"GET /?temp=" << temp << "&heartRate=" << heartRate << " HTTP/1.1\\r\\nHost: 18.218.170.174\\r\\nConnection: keep-alive\\r\\nAccept: */*\\r\\n\\r\\n\")\r\n";

    strcpy(snd,"conn=net.createConnection(net.TCP, 0)\r\n");
    SendCMD();
//    getreply();
    wait(1);
//    
    strcpy(snd,"conn:on(\"receive\", function(sck, c) print(c) end )\r\n");
    SendCMD();
//    getreply();
    wait(1);
    
    strcpy(snd,"conn:connect(8080,\"18.218.170.174\")\r\n");
    SendCMD();
//    getreply();
    wait(1);
    
    strcpy(snd, getRequest.str().c_str());
    SendCMD();
//    timeout=1;
//    getreply();
////    
////    pc.printf(buf);
////    pc.printf("\r\nDONE");
}

std::string getWeather(){
        
    pc.printf("\n---------- Getting Weather ----------\r\n");
    
    std::ostringstream getRequest;
    getRequest << "conn:send(\"GET /data/2.5/weather?q=Atlanta&APPID=b874d9efc9f1f67309cd8b6ed596ef1a HTTP/1.1\\r\\nHost: api.openweathermap.org\\r\\nConnection: close\\r\\nAccept: */*\\r\\n\\r\\n\")\r\n";

    strcpy(snd,"conn=net.createConnection(net.TCP, 0)\r\n");
    SendCMD();
    getreply();
    wait(1);
    
    strcpy(snd,"conn:on(\"receive\", function(sck, c) print(c) end )\r\n");
    SendCMD();
    getreply();
    wait(1);
    
    strcpy(snd,"conn:connect(80,\"api.openweathermap.org\")\r\n");
    SendCMD();
    getreply();
    wait(1);
    
    strcpy(snd, getRequest.str().c_str());
    SendCMD();
    timeout=1;
    getreply();
    pc.printf("Weather Response:\n");
    std::string reply(buf);
    pc.printf(buf);
    pc.printf("\r\nDONE");
    return reply;
}
 
void SendCMD()
{
    esp.printf("%s", snd);
}
 
void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}
 
    