#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include <string>
#include <vector>
#include "wifi.h"
#include "TMP36.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "algorithm.h"
#include "MAX30102.h"
#include <algorithm>

#define MAX_BRIGHTNESS 255

TMP36 myTMP36(p15);
uLCD_4DGL uLCD(p9, p10, p11);
DigitalOut myled(LED1);
RawSerial blue(p28,p27);
AnalogIn compassIn(p19);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
//wave_player waver(&DACout);
//DigitalOut led2(LED2);

////Heart Rate Monitor Things
//uint32_t aun_ir_buffer[500]; //IR LED sensor data
//int32_t n_ir_buffer_length;    //data length
//uint32_t aun_red_buffer[500];    //Red LED sensor data
//int32_t n_sp02; //SPO2 value
//int8_t ch_spo2_valid;   //indicator to show if the SP02 calculation is valid
//int32_t n_heart_rate;   //heart rate value
//int8_t  ch_hr_valid;    //indicator to show if the heart rate calculation is valid
//uint8_t uch_dummy;
//#ifdef TARGET_KL25Z 
//PwmOut led(PTB18);  //initializes the pwm output that connects to the on board LED
//DigitalIn INT(PTD1);  //pin PTD1 connects to the interrupt output pin of the MAX30102
//#endif
//#ifdef TARGET_K64F
//DigitalIn INT(PTD1);  //pin PTD1 connects to the interrupt output pin of the MAX30102
//#endif
//#ifdef TARGET_MAX32600MBED
//PwmOut led(LED_RED);    //initializes the pwm output that connects to the on board LED
//DigitalIn INT(p20);  //pin P20 connects to the interrupt output pin of the MAX30102
//#endif
//

int state = 1;
int state_old = 1;

// AUDIO //////////////////////////////////////////////////////////////
int button = 0;

vector<string> filenames; //filenames are stored in a vector string
int lines = 16;
int shiftIndex = 0;
string curPath;
bool cont = false;

int getMin(int a, int b)
{
    if (a < b)
    {
        return a;
    }
    return b;
}
 
void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
    closedir(dp);
}

void dirRead(string str)
{
    filenames.clear();
    read_file_names((char*) str.c_str());
}



bool isFolder(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    if ((dp = opendir(dir)) == NULL)
    {
        return false;
    }
    return true;
}

void fillIndex(int index, int color)
{
    shiftIndex = 0;
    string temp = filenames.at(index);
    if (temp.length() > 16)
    {
        temp = temp.substr(0, 16);
    }
    if (color == 1)
    {
        uLCD.color(RED);
    }
    else
    {
        uLCD.color(WHITE);
    }
    uLCD.locate(0, index % lines);
    uLCD.printf(temp.c_str());
}

void fillPage(int start, int index)
{
    if (start < filenames.size())
    {
        for (int i = start; i < getMin(start + lines, filenames.size()); i++)
        {
            if (i == index)
            {
                fillIndex(i, 1);
            }
            else
            {
                fillIndex(i, 0);
            }
        }
    }
}

void shiftLine(int index)
{
    string temp = filenames.at(index);
    if (temp.length() > 16)
    {
        uLCD.color(RED);
        shiftIndex = (shiftIndex++) % (temp.length() - 16);
        temp = temp.substr(shiftIndex, 16);
        uLCD.locate(0, index % lines);
        uLCD.printf(temp.c_str());
    }
}

string browse(string dir)
{
    uLCD.cls();
    dirRead(dir);
    int pageNum = 0;
    string selected;
    int index = 0;
    
    fillPage(pageNum, index);
    
    while(true)
    {
        if (state != state_old) {
            cont = true;
            break;
        }
        if (button == 1)
        {
            button = 0;
            Thread::wait(100);
            if (index > 0)
            {
                index--;
                if (index < pageNum)
                {
                    pageNum = pageNum - lines;
                    fillPage(pageNum, index);
                }
                else
                {
                    fillIndex(index + 1, 0);
                    fillIndex(index, 1);
                }
            }
        }
        else if (button == 2)
        {
            button = 0;
            Thread::wait(100);
            if (index < filenames.size() - 1)
            {
                index++;
                if (index >= pageNum + lines)
                {
                    pageNum = pageNum + lines;
                    fillPage(pageNum, index);
                }
                else
                {
                    fillIndex(index - 1, 0);
                    fillIndex(index, 1);
                }
            }
        }
        else if (button == 4)
        {
            button = 0;
            Thread::wait(100);
            if (isFolder((char*) (dir + "/" + filenames.at(index)).c_str()))
            {
                selected = browse(dir + "/" + filenames.at(index));
                if (!selected.empty())
                {
                    return selected;
                }
                else
                {
                    uLCD.cls();
                    dirRead(dir);
                    fillPage(pageNum, index);
                }
            }
            else
            {
                string testStr = filenames.at(index);
                if ((testStr.length() > 4) && (testStr.compare(testStr.length() - 4, 4, ".wav") == 0))
                {
                    return dir + "/" + filenames.at(index);
                }
            }
        }
        else if (button == 3)
        {
            button = 6;
            Thread::wait(100);
            return (string)"";
        }
        else
        {
            Thread::wait(100);
            shiftLine(index);
        }
    }
    return filenames.at(index);
}
////////////////////////////////////////////////

float tempC, tempF;
int heartRate = 60;
float headingDegrees = 0;
Mutex wifi_mutex;
Mutex global_mutex;

int getTemp() {
    tempC = myTMP36;
    tempF = ((tempC)*(9.0/5.0) + 32.0);
    return tempF;
}

void sendThread() {
    while(1){
        wifi_mutex.lock();
        sendData(getTemp(), heartRate);
        wifi_mutex.unlock();
        heartRate += (rand() % 2)*2-1;
        Thread::wait(100);
    }
}

void debugThread() {
    myled = 0;
    while(1) {
        myled = !myled;
        Thread::wait(500);
    }
}

class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};
 
RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}
 
void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}

RGBLed rgbled(p23,p22,p21);

void uLCDThread() {
    while (1) {
        state_old = state;
        std::string weather;
        switch(state) {
            case 1: {
//                wifi_mutex.lock();
//                weather = getWeather();
//                wifi_mutex.unlock();
//                rgbled.write(1.0f, 1.0f, 1.0f);
//                uLCD.locate(0, 0);
//                uLCD.printf("4180 Smart Watch\n");
//                uLCD.printf(weather.c_str());
//                time_t rawtime;
//                struct tm * timeinfo;
//                char buffer[80];
//                time (&rawtime);
//                timeinfo = localtime(&rawtime);
//                strftime(buffer,sizeof(buffer),"%d-%m-%Y %H:%M:%S",timeinfo);
//                std::string str(buffer);
//                uLCD.printf(str.c_str());
                while(1) {
                    uLCD.cls();
                    if (state != state_old) break;
                    Thread::wait(100);
                }
                uLCD.cls();
                break;
            }
            case 2: {
                uLCD.filled_circle(61, 63, 59, WHITE);
                uLCD.filled_circle(61, 63, 53, BLACK);
                uLCD.filled_circle(61, 63, 36, DGREY);
                uLCD.locate(7,2);
                uLCD.text_mode(TRANSPARENT);
                uLCD.color(WHITE);
                uLCD.printf("temp");
                while(1) {
                    tempC = myTMP36;
                    tempF = ((tempC)*(9.0/5.0) + 32.0);
                    if (tempF < 20) {
                        rgbled.write(0.0f, 0.0f, 1.0f);
                    } else if (tempF < 40) {
                        rgbled.write(0.0f, 0.6f, 1.0f);
                    } else if (tempF < 60) {
                        rgbled.write(1.0f, 1.0f, 0.0f);
                    } else if (tempF < 80) {
                        rgbled.write(1.0f, 0.6f, 1.0f);
                    } else {
                        rgbled.write(1.0f, 0.0f, 0.0f);
                    } 
                    uLCD.textbackground_color(DGREY);
                    uLCD.color(BLACK);
                    uLCD.locate (7, 11);
                    uLCD.locate (8, 13);
                    uLCD.text_mode(OPAQUE);
                    uLCD.textbackground_color(BLACK);
                    uLCD.printf ("--");
                    uLCD.text_mode(TRANSPARENT);
                    uLCD.color(WHITE);
                    uLCD.locate (5, 6);
                    uLCD.text_width(4);
                    uLCD.text_height(4);
                    uLCD.text_mode(OPAQUE);
                    uLCD.textbackground_color(DGREY);
                    uLCD.printf("%.0F\n", tempF);
                    uLCD.text_mode(TRANSPARENT);
                    uLCD.text_width(1);
                    uLCD.text_height(1);
                    Thread::wait(500);
                    if (state != state_old) break;
                }
                uLCD.cls();
                break;
            }
            case 3: {
                uLCD.filled_circle(61, 63, 59, WHITE);
                uLCD.filled_circle(61, 63, 53, BLACK);
                uLCD.filled_circle(61, 63, 36, RED);
                uLCD.locate(7,2);
                uLCD.text_mode(TRANSPARENT);
                uLCD.color(WHITE);
                uLCD.printf(" HR");
                while(1) {
                    if (heartRate < 60) {
                        rgbled.write(0.3f, 0.6f, 1.0f);
                    } else if (heartRate < 110) {
                        rgbled.write(0.8f, 1.0f, 0.3f);
                    } else if (heartRate < 160) {
                        rgbled.write(1.0f, 0.8f, 1.0f);
                    } else {
                        rgbled.write(1.0f, 0.0f, 0.0f);
                    } 
                    uLCD.textbackground_color(DGREY);
                    uLCD.color(BLACK);
                    uLCD.locate (7, 11);
                    uLCD.locate (8, 13);
                    uLCD.text_mode(OPAQUE);
                    uLCD.textbackground_color(BLACK);
                    uLCD.printf ("--");
                    uLCD.text_mode(TRANSPARENT);
                    uLCD.color(WHITE);
                    uLCD.locate (6, 7);
                    uLCD.text_width(2);
                    uLCD.text_height(2);
                    uLCD.text_mode(OPAQUE);
                    uLCD.textbackground_color(RED);
                    uLCD.filled_circle(61, 63, 36, RED);
                    uLCD.printf("%i", heartRate);
                    uLCD.text_mode(TRANSPARENT);
                    uLCD.text_width(1);
                    uLCD.text_height(1);
                    Thread::wait(500);
                    if (state != state_old) break;
                }
                uLCD.cls();
                break;
            }
            case 4: {
                while(1) {
                    uLCD.cls();
                    uLCD.background_color(BLACK);
                    
                    uLCD.locate(0,0);
                    
                    float headingRadians = headingDegrees * (3.14159 / 180) * -1.0;
                    
                    int needleX = 63 + ((int)(63.0 * cos(headingRadians)));
                    int needleY = 63 + ((int)(63.0 * sin(headingRadians)));
                    
                    uLCD.line(63, 63, needleX, needleY, RED);
                    Thread::wait(500);
                    if (state != state_old) break;
                }
                uLCD.cls();
                break;
            }
            case 5: {
                while (1)
                    {
                        uLCD.background_color(BLACK);
                        string testString = browse("/sd");
                        uLCD.cls();
                        if (!cont) {
                            FILE *wave_file;
                            if (!testString.empty())
                            {
                                uLCD.locate(0, 0);
                                uLCD.printf(testString.c_str());
                                wave_file=fopen(testString.c_str(), "r");
                                //waver.play(wave_file);
                                fclose(wave_file);
                            }
                        }
                        Thread::wait(500);
                        if ((state != state_old) || cont) break;
                    }
                    cont = false;
                    uLCD.cls();
                    break;
            }
        }
    }
}

void blue_recv() {
    char bnum=0;
    char bhit=0;
    while(blue.readable()) {
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                state = 1;
                            } else {
                                //add release code here
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                state = 2;
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                state = 3;
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                                state = 4;
                            } else {
                                //add release code here
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                //add hit code here
                                if (state != 5) {
                                    state = 5;
                                } else {
                                    button = 1;
                                }
                            } else {
                                //add release code here
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                button = 2;
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                button = 3;
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                button = 4;
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
    
}

//void heartRateThread() {
//    // Create the original background for the UI design
//    uLCD.filled_circle(61, 63, 59, WHITE);
//    uLCD.filled_circle(61, 63, 53, BLACK);
//    uLCD.filled_circle(61, 63, 36, RED);
//    uLCD.locate(7,2);
//    uLCD.text_mode(TRANSPARENT);
//    uLCD.color(WHITE);
//    uLCD.printf(" HR");
//            
//    uint32_t un_min, un_max, un_prev_data;  //variables to calculate the on-board LED brightness that reflects the heartbeats
//    int i;
//    int32_t n_brightness;
//    float f_temp;
//    DigitalIn INT(p20);
//    
//    maxim_max30102_reset(); //resets the MAX30102
//    // initialize serial communication at 115200 bits per second:
//    pc.baud(9600);
//    pc.format(8,SerialBase::None,1);
//    wait(1);
//    
//    //read and clear status register
//    maxim_max30102_read_reg(0,&uch_dummy);
//    
//    //wait until the user presses a key
//    while(pc.readable()==0)
//    {
//        pc.printf("\x1B[2J");  //clear terminal program screen
//        pc.printf("Press any key to start conversion\n\r");
//        wait(1);
//    }
//    uch_dummy=getchar();
//    
//    maxim_max30102_init();  //initializes the MAX30102
//        
//        
//    n_brightness=0;
//    un_min=0x3FFFF;
//    un_max=0;
//  
//    n_ir_buffer_length=500; //buffer length of 100 stores 5 seconds of samples running at 100sps
//    
//    //read the first 500 samples, and determine the signal range
//    for(i=0;i<n_ir_buffer_length;i++)
//    {
//        while(INT.read()==1);   //wait until the interrupt pin asserts
//        
//        maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));  //read from MAX30102 FIFO
//            
//        if(un_min>aun_red_buffer[i])
//            un_min=aun_red_buffer[i];    //update signal min
//        if(un_max<aun_red_buffer[i])
//            un_max=aun_red_buffer[i];    //update signal max
//        pc.printf("red=");
//        pc.printf("%i", aun_red_buffer[i]);
//        pc.printf(", ir=");
//        pc.printf("%i\n\r", aun_ir_buffer[i]);
//    }
//    un_prev_data=aun_red_buffer[i];
//    
//    
//    //calculate heart rate and SpO2 after first 500 samples (first 5 seconds of samples)
//    maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid); 
//    
//    //Continuously taking samples from MAX30102.  Heart rate and SpO2 are calculated every 1 second
//    while(1)
//    {
//        i=0;
//        un_min=0x3FFFF;
//        un_max=0;
//        
//        //dumping the first 100 sets of samples in the memory and shift the last 400 sets of samples to the top
//        for(i=100;i<500;i++)
//        {
//            aun_red_buffer[i-100]=aun_red_buffer[i];
//            aun_ir_buffer[i-100]=aun_ir_buffer[i];
//            
//            //update the signal min and max
//            if(un_min>aun_red_buffer[i])
//            un_min=aun_red_buffer[i];
//            if(un_max<aun_red_buffer[i])
//            un_max=aun_red_buffer[i];
//        }
//        
//        //take 100 sets of samples before calculating the heart rate.
//        for(i=400;i<500;i++)
//        {
//            un_prev_data=aun_red_buffer[i-1];
//            while(INT.read()==1);
//            maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));
//        
//            if(aun_red_buffer[i]>un_prev_data)
//            {
//                f_temp=aun_red_buffer[i]-un_prev_data;
//                f_temp/=(un_max-un_min);
//                f_temp*=MAX_BRIGHTNESS;
//                n_brightness-=(int)f_temp;
//                if(n_brightness<0)
//                    n_brightness=0;
//            }
//            else
//            {
//                f_temp=un_prev_data-aun_red_buffer[i];
//                f_temp/=(un_max-un_min);
//                f_temp*=MAX_BRIGHTNESS;
//                n_brightness+=(int)f_temp;
//                if(n_brightness>MAX_BRIGHTNESS)
//                    n_brightness=MAX_BRIGHTNESS;
//            }
//#if defined(TARGET_KL25Z) || defined(TARGET_MAX32600MBED)
//            led.write(1-(float)n_brightness/256);
//#endif
//            //send samples and calculation result to terminal program through UART
//            pc.printf("red=");
//            pc.printf("%i", aun_red_buffer[i]);
//            pc.printf(", ir=");
//            pc.printf("%i", aun_ir_buffer[i]);
//            pc.printf(", HR=%i, ", n_heart_rate); 
//            pc.printf("HRvalid=%i, ", ch_hr_valid);
//            pc.printf("SpO2=%i, ", n_sp02);
//            pc.printf("SPO2Valid=%i\n\r", ch_spo2_valid);
//        }
//        maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid); 
//        
//                        uLCD.textbackground_color(DGREY);
//                        uLCD.color(BLACK);
//                        uLCD.locate (7, 11);
//                        uLCD.locate (8, 13);
//                        uLCD.text_mode(OPAQUE);
//                        uLCD.textbackground_color(BLACK);
//                        uLCD.printf ("--");
//                        uLCD.text_mode(TRANSPARENT);
//                        uLCD.color(WHITE);
//                            uLCD.locate (6, 7);
//                            uLCD.text_width(2);
//                            uLCD.text_height(2);
//                            uLCD.text_mode(OPAQUE);
//                            uLCD.textbackground_color(RED);
//                            uLCD.filled_circle(61, 63, 36, RED);
//                            uLCD.printf("%i", n_heart_rate);
//                            uLCD.text_mode(TRANSPARENT);
//                            uLCD.text_width(1);
//                            uLCD.text_height(1);
//                        wait(0.5);
//    }
//}

int main() {
    esp.baud(9600);
    ESPconfig();
    Thread t1;
    Thread t2;
    Thread t3;
    Thread t4;
    t1.start(sendThread);
    t2.start(debugThread);
    t3.start(uLCDThread);
//    t4.start(heartRateThread);
    blue.attach(&blue_recv, Serial::RxIrq);
    while (1) {
        headingDegrees = compassIn*360.0f;
        Thread::wait(100);
    }
}
