# xDotBridge Documentation {#mainpage}
## Introduction 
This project is intended to support multiple products including Wireless
Bridge, MTS comm board, and camera comm board.  The stretch goal of using a
single binary and intuiting all the different configurations.  At a minimum it
should allow at compile time switches to generate different flavors.

# Software Design
## File structure
The software is written using mbed's standard layout and is compatible with
their online compiler.

### Top Level Contents
 * 3rd party libraries such as libxDot, mbed-os, and OneWire.
 * Doxyfile used to generate nice looking documentation.

### xDotBridge (subfolder)
 * Contains standard folders for C++ headers and source
 * This readme file
 * config.h which contains compile time options

## Code organization
The software has been designed in a object oriented way and separates
functionality such that communication protocol can be changed separately
from I/O SCADA. The design will hopefully allow additional modules to utilize
both IO and communication without major software revisions.  The main
components are listed below:

### CommProtocol
This set of classes implements different protocols this allows the user to
select between P2P or WAN.

### Baseboard IO
This class allows for control and status of various GPIO either directly
connect to uC or through OneWire port expanders.  The idea is to make the
main code less busy with implementation details.

### Additional daughter board module (MTS)
Mostly TBD.  Hopefully can just register to commModule to communicate alerts and
receive configuration information.

### Bootloader Staging
This future class will load firmware from over the air into a on-board flash.
Provide integrity checking functions and eventually reset uC for main bootloader. 

### Main
The main file has a while loop which will sample IO, stimulate IO, apply
configuration changes, then put the uC to sleep and wait for either a timer
event or an external interrupt i.e. each iteration of the while loop is
relatively independent and all state should be stored in other classes.

### Bootloader
The bootloader is a separate program which is ran during the boot of uC and
is used to load new firmware either though serial (via a TBD protocol) or if
a firmware is properly staged in the flash will automatically check and apply
this firmware to main memory.  Finally it will exit by jumping to the main program.

TODO Figure out best way to compile these projects with offsets or with a combiner
program.

# Theory of operation
## Peer to Peer Operation
After pairing (described in separate section) a set of transmitters (TXs) and
receivers (RXs) will have a network addresses?, unique network session keys,
and data session keys.  This guarantees by design that all message sent can
only be received and decoded by units in the pair group.

### Important LoRaWAN Parameters
For peer to peer only a subset of parameters apply.  Many are obvious such as
power, frequency, and basic command and control.  Below are a listing of the more
detailed parameters and our current understanding as to how they effect performance:

 * Network address  - In peer to peer this acts both as a tx and rx address.  In other
 words if all the modems are the same address messages act as broadcast.  For the
 wireless bridge, this is used as a sort of network ID since all communication is
 broadcast.
 * Network session key - This is one of two encryption key.  Currently, in peer to peer
 both are just randomly generated.
 * Data session key - This is second of two encryption key.  Currently, in peer to peer
 both are just randomly generated.

Not applicable parameters:
 * Network ID - Used for OTA
 * Network Key - Used for OTA

### Brute force algorithm
TODO

#### Brute force alert message

 Offset | Size (in Bytes) | Name            
------- | --------------- |-----------------
 0x00   | 2 Bytes         | Alert Msg Flag  (0xEF10)  
 0x02   | 8 Bytes         | xDot EUI                  
 0x0A   | 2 Bytes         | Alert Data                
 0x0C   | 4 Bytes         | Alert Sequence Number     

Total of 16 bytes

#### Brute force pair request message

 Offset | Size (in Bytes) | Name            
------- | --------------- |-----------------
 0x00   | 2 Bytes         | Pair Request Flag (0xFE01)
 0x02   | 8 Bytes         | xDot EUI (requester)      
 0x0A   | 6 Bytes         | Reserved                  

* Total of 16 Bytes

Ideas for reserved:
 * Network type desired
 * Messages generated

#### Brute force pair accept message

 Offset | Size (in Bytes) | Name            
------- | --------------- | -----------------
 0x00   | 2 Bytes         | Pair Accept Flag (0xFD02) 
 0x02   | 8 Bytes         | xDot EUI (RX Master)      
 0x0A   | 4 Bytes         | Reserved for Frequency    
 0x0E   | 4 Bytes         | Network Address           
 0x12   | 16 Bytes        | Network Session Key      
 0x22   | 16 Bytes        | Data session Key         

* Total of 34 Bytes

## Peer to Peer Pair
Pairing needs to support many topologies including one TX to one RX, many TX to
one RX, and finally many TX to many RX.  The pairing process not only has the
units sharing their unique IDs but also their encryption keys.  To better
understand the pairing logic an example with a single RX and TX is described
and then extended to include other topologies.

### Pair a single RX to TX:
1.  Set oen unit to RX via DIP switch.  
2.  Hold the pair button for 10 seconds which clears current pair settings and generates
new pair values (This is indicated by TBD blink sequence).
3.  On the RX press the pair button which will place the unit pairing mode for 30 seconds
4.  Set the second unit to TX via DIP switch
5.  Hold TX pair button for 5 seconds to send pair request
6.  If pairing was successful both RX and TX will show TBD2 blink sequence
7.  Now both units will have the same encryption keys and be able to wireless bridge to
each other.  Pairing is complete.

Now that the general pairing work flow is introduced it can be extended to add additional TXs
and RXs to pair group.

### Adding additional TX to pair group:
1.  Set an already paired RX to enter pairing mode by pressing pair button
2.  Set new unit to TX via DIP switch
3.  Hold TX pair button for 5 seconds to send pair request
4.  If pairing was successful both RX and TX will show TBD2 blink sequence
5.  The additional TX is now paired and RX will receive alerts from all paired TXs

### Add additional RXs to pair group:
1.  To add an additional RX.  Pair it using the exact same process as adding a TX
utilizing the above instructions _i.e. pair the unit whichh will eventually become a
RX as if was a TX_.
2.  When pairing as a TX is complete; Convert the paired TX to a paired RX by switching the DIP
switch to RX mode.  This RX will now receive any TX alerts which are in range an in pair group.

#### Additional pairing thoughts
* With this scheme it is easy to add additional nodes to pair group since within the
pair group all RXs that are paired can receive any new/existing TX.
* Another way to thing of this is each pair group has a single key and does not keep
track of the copies.
* This scheme does not support hybrid pairing where two RX can receive one TX
and one of the two can receive additional TX messages the other cannot.  It might be
possible to support this but the pairing process would become more complex.

#### Pair message details

## LoRaWAN
Just use the xDots and the conduit as they are designed to be used.  No pairing just straight LoRaWAN.

* Future idea maybe a RX with WAN enabled acts as a repeater to conduit.

# Nonvolatile Memory Map
## Stored by dot firmware
 * 64-bit EUI
 * DLC
 * ULC

## Protocol Parameters

 Dot Relative Addr | Size (in Bytes) | Name 
 ----------------- | --------------- | ---------
 0x1000            | 02 Bytes        | Protocol Flag          
 0x1002            | 02 Bytes        | Protocol Rev           
 0x1004            | 04 Bytes        | Reserved for Frequency 
 0x1008            | 04 Bytes        | Network Address        
 0x1010            | 16 Bytes        | Network Session Key    
 0x1020            | 16 Bytes        | Data Session Key       
 0x1030            | 02 Bytes        | Logical Address Serial 
 0x1032            | 04 Bytes        | Last Message SeqNum    

Space needed is 50 bytes.  Spaced used is 54 bytes
for better word alignment.

## IO Baseboard Parameters

 Dot Relative Addr | Size (in Bytes) | Name
 ----------------- | --------------- | ---------
 0x1100            | 2 Bytes         | Baseboard Flag          
 0x1102            | 2 Bytes         | Baseboard Rev           
 0x1104            | 2 Bytes         | Baseboard Serial        
 0x1106            | 2 Bytes         | Baseboard Configuration 
 0x1110            | 8 Bytes         | PortEx0 64 bit ROM Addr 
 0x1118            | 8 Bytes         | PortEx1 64 bit ROM Addr 

Space needed is 24 bytes.  Space used is 32 bytes.

