/*
 * nBitAnalogLadder.h
 *
 * This library converts analog voltage to to a bit value.  This is a table based implementation
 * so the thresholds are hard-coded and can be adjusted.
 *
 */

#include <stdint.h>

#ifndef XDOTBRIDGE_INC_NBITANALOGLADDER_H_
#define XDOTBRIDGE_INC_NBITANALOGLADDER_H_

const uint8_t TABLE_MIN_IDX = 0;
const uint8_t TABLE_MAX_IDX = 1;
const float NOM_VCC = 3.3;  // Used so table values can be in voltage not relative values

// Use voltage values in numerator
const float tenValueTable [][2] = {
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 0
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 1
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 2
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 3
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 4
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 5
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 6
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 7
		{0.0/NOM_VCC, 0.1/NOM_VCC}, // 8
		{0.0/NOM_VCC, 0.1/NOM_VCC}  // 9
};

uint8_t convAnalogLadder (const float &analogV, const float valueTable[][2], uint8_t nVals);

#endif /* XDOTBRIDGE_INC_NBITANALOGLADDER_H_ */
