#include "mbed.h"
#include "stm32l1xx_hal_pwr.h"
#include "../../config.h"

#ifdef __TEST_PVD__

Serial pc(USBTX, USBRX); // Externally defined

extern void Error_Handler(void);

volatile uint8_t pvdIntCnt;
DigitalOut gpio0(GPIO0);

void HAL_PWR_PVDCallback(void) {
    gpio0 = 1;
    pvdIntCnt++;
    /* Clear PWR Exti pending bit */
    __HAL_PWR_PVD_EXTI_CLEAR_FLAG();  // Just to be extra sure
}
int main ()
{
    HAL_MspInit();
    pvdIntCnt = 0;

    pc.baud(115200);

    while (true) {
        pc.printf("PVD_INT_CNT %d, EXTI_GET_FLAG %d\r\n", pvdIntCnt, __HAL_PWR_PVD_EXTI_GET_FLAG());
        wait(0.1);
    }
    return 0;
}
void HAL_MspInit(void)
{
  /* USER CODE BEGIN MspInit 0 */
  /* USER CODE END MspInit 0 */
  PWR_PVDTypeDef sConfigPVD;
  __HAL_RCC_COMP_CLK_ENABLE();
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
  HAL_NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);
  /* System interrupt init*/
  /* MemoryManagement_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(MemoryManagement_IRQn, 0, 0);
  /* BusFault_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(BusFault_IRQn, 0, 0);
  /* UsageFault_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(UsageFault_IRQn, 0, 0);
  /* SVC_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(SVC_IRQn, 0, 0);
  /* DebugMonitor_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(DebugMonitor_IRQn, 0, 0);
  /* PendSV_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(PendSV_IRQn, 0, 0);
  /* SysTick_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(SysTick_IRQn, 0, 0);
  /* Peripheral interrupt init*/
  /* PVD_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(PVD_IRQn, 1, 0);
  HAL_NVIC_EnableIRQ(PVD_IRQn);  // If not commented out program will hard fault but does not interrupt
    /**PVD Configuration
    */
  sConfigPVD.PVDLevel = PWR_PVDLEVEL_5;
  sConfigPVD.Mode = PWR_PVD_MODE_IT_RISING_FALLING;
//  sConfigPVD.Mode = PWR_PVD_MODE_EVENT_RISING;
  HAL_PWR_ConfigPVD(&sConfigPVD);
    /**Enable the PVD Output
    */
  HAL_PWR_EnablePVD();
  /* USER CODE BEGIN MspInit 1 */
  /* USER CODE END MspInit 1 */
}

#endif
