/*
 * SerialTermMgr.h
 *
 *  Created on: May 8, 2017
 *      Author: mbriggs
 */

#ifndef XDOTBRIDGE_INC_SERIALTERMMGR_H_
#define XDOTBRIDGE_INC_SERIALTERMMGR_H_

#include "mbed.h"
#include "BufferedSerial.h"
#include "WinbondSPIFlash.h"
#include "BaseboardIO.h"

const uint32_t TERM_BAUD = 115200;
const uint8_t TERM_TIMEOUT = 30; // In seconds

const float XMODEM_TIMEOUT = 10.0;
const unsigned char MAX_TIMEOUTS = 6; // multiple by TIMEOUT above.  60 total seconds
const uint16_t FLASH_BIN_OFFSET = 256; // Skip first flash page
const uint16_t XMODEM_PACKET_SIZE = 128;
const char NEW_CODE [] = "NEWCODE0";
const char END0LINE [] = "END0LINE";
const char VORTEX_UPDATE_KEY [] = "V0RT3XUPDATE";

enum ScreenId {
    mainScreenId,
    genInfoScreenId,
    settingsScreenId,
    statsScreenId,
    errorLogScreenId,
    liveLogScreenId,
    enterSerialBridgeScreenId,
    enterProgModeScreenId
};


class SerialTermMgr
{
private:
    ScreenId mCurrScreen; // Current selection
    float mFwVersion;
    BaseboardIO *mBbio; // Handle for reading states
    BufferedSerial *mPc;
    WinbondSPIFlash *mFlash;

    // Hold for seeding new values
    bool mSaveIsCCNO;
    bool mSaveIsTx;
    uint8_t mSaveRot1;

    bool inputMainPage(char in);
    void printMainScreen();
    void inputGenInfo (char in);
    void printGenInfo();
    void inputSettings (char in);
    void printSettings();
    void seedSaveSettings();
    void applySaveSettings();
    void inputEnterProgMode (char in);
    void printEnterProgMode();
    bool xmodem2Flash();
    void writeBootloaderCtrlPage(uint32_t nBytes);
public:
    SerialTermMgr(BaseboardIO *bbio, WinbondSPIFlash *flash, float fwVersion);
    void regSerial (BufferedSerial *pc) {
        mPc = pc;
    }
    ScreenId getCurrentScreenId() {
        return mCurrScreen;
    }
    void printScreen();
    bool input();
};

#endif /* XDOTBRIDGE_INC_SERIALTERMMGR_H_ */
