# Written for python 2.7

BOOTLOADER_SIZE = 0xB000
SUFFIX_UPDATE_KEY = b'V0RT3XUPDATE'
APP_TAG = '_app'
CHUNK_SIZE = 4096

import os
import sys
import Tkinter, tkFileDialog, tkMessageBox

def createNewAppBin (filename):
    (fileRoot, ext) = os.path.splitext(filename)
    outFilename = fileRoot+APP_TAG+ext
    with open(filename, 'rb') as inFile, open(outFilename, 'wb+') as outFile:
        inFile.seek(BOOTLOADER_SIZE)
        d = inFile.read(CHUNK_SIZE)
        while (d != b''):
            outFile.write(d)
            d = inFile.read(CHUNK_SIZE)
        outFile.write(SUFFIX_UPDATE_KEY)
    return outFilename

if __name__ == '__main__':
    if not 'PROMPT' in os.environ: # Detect if ran from double click
        print('Usage: %s combined_bin_filename' % sys.argv[0])
        notInCmdPrompt = True
        root = Tkinter.Tk()
        root.withdraw()

        inFilename = tkFileDialog.askopenfilename()
        if inFilename == '':
            sys.exit(1)
    else:    
        if len(sys.argv) < 2:
            print('Usage: %s combined_bin_filename' % sys.argv[0])
            sys.exit(1)
        inFilename = sys.argv[1]
    
    newFilename = createNewAppBin(inFilename)
    print('Created %s.' % newFilename)
    
    if notInCmdPrompt:
        tkMessageBox.showinfo("Done", 'Created %s.' % newFilename)

