/*
 * UserInterface.h
 *
 *  Created on: Feb 28, 2017
 *      Author: mbriggs
 */

#ifndef XDOTBRIDGE_INC_USERINTERFACE_H_
#define XDOTBRIDGE_INC_USERINTERFACE_H_

#include <stdint.h>
#include "BaseboardIO.h"

const float RX_PAIR_WAIT_TIME = 30.0;
const float TX_ACCEPT_WAIT_TIME = 10.0;

enum PairBtnState {
    pairBtnNoPress=0,
    pairBtnShortPress=1,
    pairBtnMediumPress=2,
    pairBtnLongPress=3
};

class PairBtnInterp {
public:
    // Start time < press time < stop time (all time in ms)
    static const uint16_t ShortPressStartTime = 0;
    static const uint16_t ShortPressStopTime = 4000;
    static const uint16_t MediumPressStartTime = 4000;
    static const uint16_t MediumPressStopTime  = 9000;
    // Anything longer is a LongPress

    static PairBtnState read(BaseboardIO *bbio);
};

class HoldTimeSetting {
public:
    static uint32_t rotVal2Msec(uint8_t in);
    static float rotVal2Sec(uint8_t in) {return rotVal2Msec(in)/1000.0;}
};

class LedPatterns {
public:
    LedPatterns(BaseboardIO *bbio);
    void turnOn();
    void turnOff();
    void singleBlink();
    void tripleBlink();
    void tenBlinks();
private:
    BaseboardIO *mBbio;
};
#endif /* XDOTBRIDGE_INC_USERINTERFACE_H_ */
