/*
 * MyLog.cpp
 *
 *  Heavily borrowed from MTSLog
 *
 *  Created on: Mar 14, 2017
 *      Author: mbriggs
 */

#include "MyLog.h"

#include "mbed.h"
#include <stdarg.h>

using namespace mts;

int MyLog::currentLevel = MyLog::WARNING_LEVEL;

const char* MyLog::NONE_LABEL = "NONE";
const char* MyLog::FATAL_LABEL = "FATAL";
const char* MyLog::ERROR_LABEL = "ERROR";
const char* MyLog::WARNING_LABEL = "WARNING";
const char* MyLog::INFO_LABEL = "INFO";
const char* MyLog::DEBUG_LABEL = "DEBUG";
const char* MyLog::TRACE_LABEL = "TRACE";

void MyLog::printMessage(int level, const char* format, ...) {
    if (printable(level)) {
        va_list argptr;
        va_start(argptr, format);
        vprintf(format, argptr);
        va_end(argptr);
    }
}

bool MyLog::printable(int level) {
    return level <= currentLevel;
}

void MyLog::setLogLevel(int level) {
    if (level < NONE_LEVEL)
        currentLevel = NONE_LEVEL;
    else if (level > TRACE_LEVEL)
        currentLevel = TRACE_LEVEL;
    else
    currentLevel = level;
}

int MyLog::getLogLevel() {
    return currentLevel;
}

const char* MyLog::getLogLevelString() {
    switch (currentLevel) {
        case NONE_LEVEL:
            return NONE_LABEL;
        case FATAL_LEVEL:
            return FATAL_LABEL;
        case ERROR_LEVEL:
            return ERROR_LABEL;
        case WARNING_LEVEL:
            return WARNING_LABEL;
        case INFO_LEVEL:
            return INFO_LABEL;
        case DEBUG_LEVEL:
            return DEBUG_LABEL;
        case TRACE_LEVEL:
            return TRACE_LABEL;
        default:
            return "unknown";
    }
}
