/*
 * simpleRxSeqLog.h
 *
 *  Created on: Mar 23, 2017
 *      Author: mbriggs
 */

#ifndef SIMPLERXSEQLOG_H_
#define SIMPLERXSEQLOG_H_

#include "EepromLog.h"

const uint8_t SIMPLE_RX_SEQ_LOG_SIZE = 3*sizeof(uint32_t);

class SimpleRxSeqLog : public EepromLog {
public:
    SimpleRxSeqLog (uint16_t baseAddr) : EepromLog(baseAddr, SIMPLE_RX_SEQ_LOG_SIZE) {}

    uint32_t loopCount()
    {
        return *((uint32_t *)(mData+0*sizeof(uint32_t)));
    }
    void setLoopCount(uint32_t val)
    {
        *((uint32_t*) (mData+0*sizeof(uint32_t))) = val;
    }
    uint32_t rxMsgCount()
    {
        return *((uint32_t *)(mData+1*sizeof(uint32_t)));
    }
    void setRxMsgCount(uint32_t val)
    {
        *((uint32_t*) (mData+1*sizeof(uint32_t))) = val;
    }
    uint32_t maxSeenMsgSeqNum()
    {
        return *((uint32_t*)(mData+2*sizeof(uint32_t)));
    }
    void setMaxSeenMsgSeqNum(uint32_t val)
    {
        *((uint32_t*) (mData+2*sizeof(uint32_t))) = val;
    }
};

#endif /* XDOTBRIDGE_INC_SIMPLERXSEQLOG_H_ */
