#include "DS2408.h"

enum DS2408Cmd {
    registerReadCmd        = 0xF0,
    channelAccessReadCmd   = 0xF5,
    channelAccessWriteCmd  = 0x5A
};

DS2408::DS2408(OneWire *owMaster, uint8_t romAddr[8])
{
    mMaster = owMaster;
    std::memcpy(mRomAddr, romAddr, sizeof(mRomAddr));
    disableTestMode();
}

CmdResult DS2408::registerReadReliable(uint8_t addr, uint8_t &val)
{
    uint8_t result = 0;
    uint8_t result1 = 0xFF;
    uint8_t cmdResult;
    cmdResult = registerRead(addr, result);
    for (int i=0; i < DS2408_NRETRIES; i++) {
        cmdResult = registerRead(addr, result1);
        if (cmdResult != cmdSuccess) {
            continue;
        }
        // Check they match
        if (result == result1) {
            val = result;
            return cmdSuccess;
        }
        else {
            result = result1;
        }
    }
    return cmdTimeout;
}

CmdResult DS2408::registerRead(uint8_t addr, uint8_t &val)
{
    uint8_t addrArray[] = {0x00, 0x00};
    addrArray[0] = addr;
    mMaster->reset();
    mMaster->select(mRomAddr);
    mMaster->write(registerReadCmd); // Read Register Command
    mMaster->write_bytes(addrArray, 2); // Write 2 byte addr
    val = mMaster->read();
//    logDebug("Reg Value: %02x\n", result);
    return cmdSuccess;
}

CmdResult DS2408::pioLogicRead(uint8_t &val)
{
    return registerRead(pioLogicStateReg, val);
}

CmdResult DS2408::pioLogicReliableRead(uint8_t &val)
{
    return registerReadReliable(pioLogicStateReg, val);
}

CmdResult DS2408::pioLogicWrite(uint8_t val)
{
    mMaster->reset();
    mMaster->select(mRomAddr);
    mMaster->write(channelAccessWriteCmd);
    mMaster->write(val);
    mMaster->write(~val);  // Need to write complement to ensure no bit errors
    uint8_t result = mMaster->read();
    if (result == 0xAA) {
        return cmdSuccess;
    }
    else {
        return cmdError;
    }
}

CmdResult DS2408::pioLogicReliableWrite(uint8_t val)
{
    uint8_t result;
    for (int i=0; i < DS2408_NRETRIES; i++) {
        result = pioLogicWrite(val);
        if (result == cmdSuccess) {
            return cmdSuccess;
        }
    }
    return cmdTimeout;
}

CmdResult DS2408::disableTestMode()
{
    mMaster->reset();
    mMaster->write(0x96);

    for (uint8_t i = 0; i < 8; i++) mMaster->write(mRomAddr[i]);

    mMaster->write(0x3C);
    mMaster->reset();
    return cmdSuccess;
}
