/*
 * UserInterface.cpp
 *
 */

#include "UserInterface.h"

uint32_t HoldTimeSetting::rotVal2Msec(uint8_t in) {
    switch(in) {
    case 1:
        return 10e3; // 10 sec
        break;
    case 2:
        return 20e3; // 20 sec
        break;
    case 3:
        return 30e3; // 30 sec
        break;
    case 4:
        return 40e3; // 40 sec
        break;
    case 5:
        return 50e3; // 50 sec
        break;
    case 6:
        return 60e3; // 60 sec
        break;
    case 7:
        return 2*60e3; // 2 mins
        break;
    case 8:
        return 5*60e3; // 5 mins
        break;
    case 9:
        return 10*60e3; // 10 mins
        break;
    case 0:
        return 500; // 0.5 sec
        break;
    default:  // Match case 0
        return 500; // 0.5 sec
    }
}

PairBtnState PairBtnInterp::read(BaseboardIO *bbio)
{
    const uint8_t holdCnt2ms = 100; // 100 ms per 0.1 sec count
    uint8_t holdCnt = 0;
    for (holdCnt=0; holdCnt < 90; holdCnt++) {
        if (bbio->isPairBtn() == false){ // Button released
            break;
        }
        // TODO Sleep here rather than just wait
        wait(0.1);
    }
    if (ShortPressStartTime <= holdCnt*holdCnt2ms
        && holdCnt*holdCnt2ms < ShortPressStopTime) {
        return pairBtnShortPress;
    }
    else if (MediumPressStartTime <= holdCnt*holdCnt2ms
            && holdCnt*holdCnt2ms < MediumPressStopTime) {
        return pairBtnMediumPress;
    }
    else {
        return pairBtnLongPress;
    }
}

LedPatterns::LedPatterns(BaseboardIO *bbio)
{
    mBbio = bbio;
}

void LedPatterns::turnOn()
{
    mBbio->ledOn();
}

void LedPatterns::turnOff()
{
    mBbio->ledOff();
}

void LedPatterns::singleBlink()
{
    mBbio->ledOn();
    wait(0.5);
    mBbio->ledOff();
}

void LedPatterns::tripleBlink()
{
    singleBlink();
    wait(0.5);
    singleBlink();
    wait(0.5);
    singleBlink();
}

void LedPatterns::tenBlinks()
{
    for (uint8_t i=0; i<10; i++) {
        singleBlink();
        wait(0.5);
    }
}
