/*
 * EepromLog.cpp
 *
 *  Created on: Mar 23, 2017
 *      Author: mbriggs
 */

#include "EepromLog.h"
#include "dot_util.h"
#include <cstring>

EepromLog::EepromLog(uint16_t baseAddr, uint8_t size)
{
    mBaseAddr = baseAddr;
    mLogSize = size;
    mData = new uint8_t[size];
}
EepromLog::~EepromLog()
{
    mLogSize=0;
    delete mData;
}
void EepromLog::clear()
{
    if (mLogSize == 0 || mData == NULL)
        return;
    std::memset(mData, 0x00, mLogSize);
}
bool EepromLog::read()
{
    if (mLogSize == 0 || mData == NULL)
        return false;
    return dot->nvmRead(mBaseAddr, mData, mLogSize);
}
bool EepromLog::save()
{
    if (mLogSize == 0 || mData == NULL)
        return false;
    return dot->nvmWrite(mBaseAddr, mData, mLogSize);
}
