#include "mbed.h"
#include "../../config.h"
#include "CommProtocolPeerBrute.h"
//#include "BaseboardIO.h"
//#include "MTSLog.h"
#include "RadioEvent.h"
#include "dot_util.h"
#include "mDot.h"

#ifdef __TEST_XDOT_DEV_COMM__
Serial pc(USBTX, USBRX); // Externally defined
mDot* dot = NULL; // Used by dot-utils

const int VERSION = 0;

volatile bool ccInIntFlag;  // Wake pin

void ccInIntCallback () {
    ccInIntFlag = true;
}

InterruptIn mCCIn(WAKE);
DigitalOut led(GPIO0);
/**
 * Checks that in idle state all the IOs are pulled up.
 */
int main ()
{
    CommProtocolPeerBrute *protocol = new CommProtocolPeerBrute();
    unsigned int loopCnt = 0;
    uint16_t txSeqNum=0;
    uint16_t rxSeqNum=0;
    CmdResult result;
    std::vector<uint8_t> data;
    pc.baud(115200);
    RadioEvent events;  // Custom event handler for automatically displaying RX data
    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);
    dot = mDot::getInstance();

    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);  // This actually is very important

    dot->setEvents(&events);  // Little bonus event debug information

    protocol->init();
    dot->setWakeMode(mDot::RTC_ALARM_OR_INTERRUPT);
    dot->setWakePin(UART_CTS);

    ccInIntFlag = false;

    Callback<void()> ccInIntObj (&ccInIntCallback);
    mCCIn.rise(ccInIntCallback);
    mCCIn.mode(PullDown);
    mCCIn.enable_irq();

    uint8_t waitCharIdx = 0;

    logInfo("Version %d.  Setup complete.  Starting main loop.", VERSION);

    while (true) {
        if (ccInIntFlag) { // TX
            led = 1;
            data.clear();
            data.push_back((txSeqNum >> 8) & 0xFF);
            data.push_back(txSeqNum & 0xFF);
            std::string dataStr(data.begin(), data.end());
            logInfo("Sent msg num: %d, payload: %s", txSeqNum, dataStr.c_str());
            protocol->send(data);
            txSeqNum++;
            ccInIntFlag = false;
        }
        else { // RX
		    bool msgPending;
		    protocol->listen(msgPending);
		    logInfo("Loop Cnt %d.  Listening.", loopCnt);
		    if (msgPending) {
		        protocol->recv(data);
                std::string dataStr(data.begin(), data.end());
                logInfo("Got msg num: %d, payload: %s", rxSeqNum, dataStr.c_str());
                rxSeqNum++;
                led = 1;
                wait(0.5);
                protocol->sampleDLC();
		    }
        }

        loopCnt++;

		led = 0;
        sleep_save_io();
        sleep_configure_io();
        dot->sleep(2, mDot::RTC_ALARM_OR_INTERRUPT, false);  // Go to sleep until wake button
        sleep_restore_io();
        logInfo("\r\n================================");
    }
    return 0;
}

#endif
