#include <Misc/SystemTimer.h>


SystemTimer::SystemTimer(){

    systemUptimeMillis = 0;

    systemTicker.attach_us(this,&SystemTimer::systemTickerHandler,1000);

}

void SystemTimer::systemTickerHandler(){

    systemUptimeMillis++;

}


uint64_t SystemTimer::getUptimeMillis(){
    return systemUptimeMillis;
}


bool SystemTimer::isTimeoutPassed(uint64_t *timestampMillis, uint32_t timeoutMillis){

    if((systemUptimeMillis - *timestampMillis) > timeoutMillis){
        *timestampMillis = systemUptimeMillis;
        return true;
    }else{
        return false;
    }

}