#ifndef QUADRATURE_CONTROLLER_H
#define QUADRATURE_CONTROLLER_H

#include <mbed.h>
#include <I2C.h>
#include "rtos.h"

/*
 * Necessary for strcut sizes
 */
#pragma pack (1)

class QuadratureController{

private:
    PwmOut *pwmOut;
    Queue<float, 2> *quadrature_queue;
    Queue<float, 2> *imu_queue_steering_angle;
    osEvent steering_angle_set_event, steering_angle_current_event;
    
    uint8_t timer_steering_angle_sampling_time;
    float q_Kp, q_Ki, feed_forward_control_factor, q_esum, feed_forward, q_Ki_sampling_time;
    float q_PI_controller, q_PWM, q_e, q_output, steering_angle_set, steering_angle_current;
    
    void init();
    void check_queues();
public:
    QuadratureController(PwmOut *pwmOut, Queue<float, 2> *quadrature_queue, Queue<float, 2> *imu_queue_steering_angle);
    void cylic_control();
};

#endif