#ifndef SUPPORTSYSTEM_H_
#define SUPPORTSYSTEM_H_

#include <mbed.h>
#include <I2C.h>

/*
 * Necessary for strcut sizes
 */
#pragma pack (1)


/*
 * Data container
 */

typedef struct {
    uint8_t i2cDeviceAddress;
    uint32_t uptimeMillis;
} Main_MaintenanceRegisterDataBuffer_t;

typedef struct {

    uint8_t commandRegister;

    int32_t sensorRawXRegister;
    int32_t sensorRawYRegister;

    float velocityXRegister;
    float velocityXFilteredRegister;
    float velocityAngularRegister;
    float velocityAngularFilteredRegister;

    float positionXRegister;
    float positionYRegister;
    float positionAngleRegister;

    float conversionFactorRegister;

    float sensorPositionXRegister;
    float sensorPositionYRegister;
    float sensorPositionAngleRegister;

    int32_t curveRadiusRegister;

    float distanceXRegister;

    uint16_t squal;

    uint16_t completeChecksum;
//  uint16_t velocityChecksumRegister;
//  uint16_t positionChecksumRegister;

} IMU_RegisterDataBuffer_t;

typedef struct {
    uint8_t commands;
} LightManager_RegisterDataBuffer_t;

typedef struct {

    uint8_t  channelValid[3];
    uint16_t channelActiveTime[3];
    int8_t   channelPercent[3];
    uint16_t checksum;

} RadioDecoder_RegisterDataBuffer_t;




/*
 * Support system - software register
 */

// Maintenance
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_MAINTENANCE_OFFSET                  0
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_MAINTENANCE_ADDRESS                 (SUPPORT_SYSTEM_REGISTER_ADDRESS_MAINTENANCE_OFFSET + 0)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_MAINTENANCE_UPTIME                  (SUPPORT_SYSTEM_REGISTER_ADDRESS_MAINTENANCE_OFFSET + 1)

// IMU
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET                          sizeof(Main_MaintenanceRegisterDataBuffer_t)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_COMMAND                         (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 0)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_SENSOR_RAW_X                    (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 1)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_SENSOR_RAW_Y                    (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 5)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_VELOCITY_X                      (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 9)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_VELOCITY_X_FILTERED             (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 13)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_VELOCITY_ANGULAR                (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 17)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_VELOCITY_ANGULAR_FILTERED       (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 21)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_POSITION_X                      (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 25)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_POSITION_Y                      (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 29)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_POSITION_ANGLE                  (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 33)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_CONVERSION_FACTOR               (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 37)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_SENSOR_POSITION_X               (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 41)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_SENSOR_POSITION_Y               (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 45)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_SENSOR_POSITION_ANGLE           (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 49)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_CURVE_RADIUS                    (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 53)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_DISTANCE_X                      (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 57)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_SQUAL                           (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 61)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_COMPLETE_CHECKSUM               (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 63)

//#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_VELOCITY_CHECKSUM             (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 63)
//#define SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_POSITION_CHECKSUM             (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + 65)

// Light manager
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_LIGHTMANAGER_OFFSET                 (SUPPORT_SYSTEM_REGISTER_ADDRESS_IMU_OFFSET + sizeof(IMU_RegisterDataBuffer_t))
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_LIGHTMANAGER_COMMAND                (SUPPORT_SYSTEM_REGISTER_ADDRESS_LIGHTMANAGER_OFFSET + 0)

// Radio decoder
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET                     (SUPPORT_SYSTEM_REGISTER_ADDRESS_LIGHTMANAGER_OFFSET + sizeof(LightManager_RegisterDataBuffer_t))
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_ONE_VALID          (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 0)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_TWO_VALID          (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 1)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_THREE_VALID        (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 2)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_ONE_ACTIVE_TIME    (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 3)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_TWO_ACTIVE_TIME    (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 5)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_THREE_ACTIVE_TIME  (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 7)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_ONE_PERCENTAGE     (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 9)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_TWO_PERCENTAGE     (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 10)
#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHANNEL_THREE_PERCENTAGE   (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 11)

#define SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_CHECKSUM                   (SUPPORT_SYSTEM_REGISTER_ADDRESS_RADIODECODER_OFFSET + 12)



/*
 * LightManager
 */
#define SUPPORT_SYSTEM_LIGHTMANAGER_BIT_REMOTE_LIGHT    0
#define SUPPORT_SYSTEM_LIGHTMANAGER_BIT_SIGNAL_LEFT     1
#define SUPPORT_SYSTEM_LIGHTMANAGER_BIT_SIGNAL_RIGHT    2
#define SUPPORT_SYSTEM_LIGHTMANAGER_BIT_SIGNAL_BOTH     3
#define SUPPORT_SYSTEM_LIGHTMANAGER_BIT_BRAKE_LIGHT     4


class SupportSystem{


private:

    uint8_t i2cAddress;
    I2C *i2c;
    uint32_t transmissionErrorCount;

    uint16_t crc16_update(uint16_t crc, uint8_t a);
    uint16_t generateChecksum(void *data, size_t len);

    /*
     * IMU
     */
    uint8_t imuCommand;
    IMU_RegisterDataBuffer_t IMU_registerDataBuffer;

    /*
     * LightManager
     */
    uint8_t lightManagerCommand;
    void setLightManagerCommandBit(bool value, uint8_t bit);

    /*
     * RadioDecoder
     */
    RadioDecoder_RegisterDataBuffer_t RadioDecoder_registerDataBuffer;

public:

    SupportSystem();
    SupportSystem(uint8_t i2cAddress, I2C *i2c);

    void init(uint8_t i2cAddress, I2C *i2c);

    void readData(uint8_t registerAddress, void *buffer, size_t length);
    void writeData(uint8_t registerAddress, void *buffer, size_t length);

    uint32_t getTransmissionErrorCount();

    /*
     * Maintenance
     */
    uint32_t readMaintenanceUptimeMillis();


    /*
     * IMU
     */
    IMU_RegisterDataBuffer_t *getImuRegisterDataBuffer();
    void writeImuConfig(float *config_register, size_t length=4);



    /*
     * LightManager
     */
    void writeLightManagerCommand();
    void setLightManagerBrakeLight(bool active, bool writeOut=true);
    void setLightManagerRemoteLight(bool active, bool writeOut=true);
    void setLightManagerSignalLeft(bool active, bool writeOut=true);
    void setLightManagerSignalRight(bool active, bool writeOut=true);
    void setLightManagerSignalBoth(bool active, bool writeOut=true);

    /*
     * RadioDecoder
     */
    RadioDecoder_RegisterDataBuffer_t *getRadioDecoderRegisterDataBuffer();

};



#endif /* SUPPORTSYSTEM_H_ */
