#ifndef MACHINE_DIRECTION_CONTROLLER_H
#define MACHINE_DIRECTION_CONTROLLER_H

#include <mbed.h>
#include <I2C.h>
#include "rtos.h"

/*
 * Necessary for strcut sizes
 */
#pragma pack (1)

class MachineDirectionController{

private:
    PwmOut *pwmOut;
    Queue<float, 2> *machine_direction_queue;
    Queue<float, 2> *imu_queue_velocity;
    osEvent velocity_set_event, velocity_current_event;
    
    uint8_t timer_velocity_sampling_time;
    
    float velocity_set;
    float velocity_current;
    float l_esum, Vorsteuerung, PI_Regler, l_output, l_PWM, l_e, l_Kp, l_Ki;
    
    void init();
    void check_queues();
public:
    MachineDirectionController(PwmOut *pwmOut, Queue<float, 2> *machine_direction_queue, Queue<float, 2> *imu_queue_velocity);
    void cylic_control();
};

#endif